/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import java.io.IOException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HiveRegister;
import org.apache.gobblin.hive.policy.HiveRegistrationPolicy;
import org.apache.gobblin.hive.policy.HiveRegistrationPolicyBase;
import org.apache.gobblin.hive.spec.HiveSpec;
import org.apache.hadoop.fs.Path;

public class HiveRegisterUtils {
    private HiveRegisterUtils() {
    }

    public static void register(Iterable<String> paths, State state) throws IOException {
        try (HiveRegister hiveRegister = HiveRegister.get(state);){
            HiveRegistrationPolicy policy = HiveRegistrationPolicyBase.getPolicy(state);
            for (String path : paths) {
                for (HiveSpec spec : policy.getHiveSpecs(new Path(path))) {
                    hiveRegister.register(spec);
                }
            }
        }
    }
}

