/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.resolver.DefaultDataSchemaResolver;
import com.linkedin.data.schema.resolver.MultiFormatDataSchemaResolver;
import java.util.EnumSet;
import java.util.Set;

public class CodeUtil {
    private static final Set<DataSchema.Type> _directTypes = EnumSet.of(DataSchema.Type.BOOLEAN, new DataSchema.Type[]{DataSchema.Type.INT, DataSchema.Type.LONG, DataSchema.Type.FLOAT, DataSchema.Type.DOUBLE, DataSchema.Type.STRING, DataSchema.Type.BYTES, DataSchema.Type.ENUM});

    public static DataSchemaResolver createSchemaResolver(String resolverPath) {
        if (resolverPath == null) {
            return new DefaultDataSchemaResolver();
        }
        return MultiFormatDataSchemaResolver.withBuiltinFormats((String)resolverPath);
    }

    public static String capitalize(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static boolean isDirectType(DataSchema schema) {
        return _directTypes.contains(schema.getDereferencedType());
    }

    public static String getUnionMemberName(DataSchema memberType) {
        String name;
        if (memberType.getType() == DataSchema.Type.TYPEREF) {
            name = ((TyperefDataSchema)memberType).getName();
        } else {
            name = memberType.getUnionMemberKey();
            int lastIndex = name.lastIndexOf(46);
            if (lastIndex >= 0) {
                name = name.substring(lastIndex + 1);
            }
        }
        return CodeUtil.capitalize(name);
    }

    public static class Pair<T0, T1> {
        public T0 first;
        public T1 second;

        public Pair(T0 first, T1 second) {
            this.first = first;
            this.second = second;
        }
    }
}

