/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.jmx;

import com.linkedin.d2.discovery.PropertySerializationException;
import com.linkedin.d2.discovery.stores.PropertyStoreException;
import com.linkedin.d2.discovery.stores.file.FileStore;
import com.linkedin.d2.jmx.FileStoreJmxMBean;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;

public class FileStoreJmx<T>
implements FileStoreJmxMBean {
    private final FileStore<T> _store;

    public FileStoreJmx(FileStore<T> store) {
        this._store = store;
    }

    @Override
    public String get(String listenTo) {
        return this._store.get(listenTo) + "";
    }

    @Override
    public String getPath() {
        return this._store.getPath();
    }

    @Override
    public List<String> ls() {
        return Arrays.asList(new File(this._store.getPath()).list());
    }

    @Override
    public void put(String listenTo, String discoveryProperties) throws PropertyStoreException {
        try {
            this._store.put(listenTo, this._store.getSerializer().fromBytes(discoveryProperties.getBytes("UTF-8")));
        }
        catch (PropertySerializationException e) {
            throw new PropertyStoreException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 should never fail", e);
        }
    }

    @Override
    public void remove(String listenTo) {
        this._store.remove(listenTo);
    }

    @Override
    public long getGetCount() {
        return this._store.getGetCount();
    }

    @Override
    public long getPutCount() {
        return 0L;
    }

    @Override
    public long getRemoveCount() {
        return 0L;
    }
}

