/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.util;

import java.util.concurrent.atomic.AtomicLong;

public class Stats {
    private final long _intervalMs;
    private AtomicLong _count;
    private volatile LoadBalancerStatsSnapshot _snapshot;

    public Stats(long intervalMs) {
        this._intervalMs = intervalMs;
        this._count = new AtomicLong();
        this._snapshot = new LoadBalancerStatsSnapshot(System.currentTimeMillis(), 0L);
    }

    public void inc() {
        this.snap();
        this._count.incrementAndGet();
    }

    public long getCount() {
        this.snap();
        return this._snapshot.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snap() {
        LoadBalancerStatsSnapshot loadBalancerStatsSnapshot = this._snapshot;
        synchronized (loadBalancerStatsSnapshot) {
            if (System.currentTimeMillis() - this._snapshot.getLastUpdateMs() >= this._intervalMs) {
                this._snapshot = new LoadBalancerStatsSnapshot(System.currentTimeMillis(), this._count.get());
                this._count.set(0L);
            }
        }
    }

    public class LoadBalancerStatsSnapshot {
        private long _lastUpdateMs;
        private long _count;

        public LoadBalancerStatsSnapshot(long lastUpdateMs, long count) {
            this._lastUpdateMs = lastUpdateMs;
            this._count = count;
        }

        public long getCount() {
            return this._count;
        }

        public long getLastUpdateMs() {
            return this._lastUpdateMs;
        }
    }
}

