/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.PropertySerializationException;
import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperStore;
import com.linkedin.d2.discovery.util.LogUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperChildrenDataPublisher<T extends Map<String, V>, V>
extends ZooKeeperStore<T> {
    private static final Logger _log = LoggerFactory.getLogger(ZooKeeperChildrenDataPublisher.class);
    private static final Pattern PATH_PATTERN = Pattern.compile("(.*)/(.*)$");
    private final ZKDataWatcher _zkDataWatcher = new ZKDataWatcher();
    private final ZKChildWatcher _zkChildWatcher = new ZKChildWatcher();
    private final PropertySerializer<V> _childSerializer;

    public ZooKeeperChildrenDataPublisher(ZKConnection client, PropertySerializer<V> childSerializer, String path) {
        super(client, null, path);
        this._childSerializer = childSerializer;
    }

    @Override
    public void startPublishing(String prop) {
        LogUtil.trace(_log, "register: ", prop);
        if (this._eventBus == null) {
            throw new IllegalStateException("_eventBus must not be null when publishing");
        }
        this._zkChildWatcher.addWatch(prop);
        this._zk.getChildren(this.getPath(prop), (Watcher)this._zkChildWatcher, (AsyncCallback.ChildrenCallback)this._zkChildWatcher, (Object)true);
    }

    @Override
    public void stopPublishing(String prop) {
        LogUtil.trace(_log, "unregister: ", prop);
        this._zkChildWatcher.cancelWatch(prop);
        this._zkDataWatcher.cancelAllWatches();
    }

    @Override
    public void put(String prop, T value, Callback<None> callback) {
        callback.onError((Throwable)new UnsupportedOperationException("put is not supported"));
    }

    @Override
    public void get(String prop, Callback<T> callback) {
        callback.onError((Throwable)new UnsupportedOperationException("get is not supported"));
    }

    @Override
    public void remove(String prop, Callback<None> callback) {
        callback.onError((Throwable)new UnsupportedOperationException("remove is not supported"));
    }

    private class ZKChildWatcher
    extends ZooKeeperStore.ZKStoreWatcher
    implements AsyncCallback.ChildrenCallback,
    AsyncCallback.StatCallback {
        private ZKChildWatcher() {
            super(ZooKeeperChildrenDataPublisher.this);
        }

        @Override
        public void processWatch(String propertyName, WatchedEvent watchedEvent) {
            ZooKeeperChildrenDataPublisher.this._zk.getChildren(ZooKeeperChildrenDataPublisher.this.getPath(propertyName), (Watcher)this, (AsyncCallback.ChildrenCallback)this, (Object)false);
        }

        public void processResult(int rc, String path, Object ctx, List<String> children) {
            KeeperException.Code code = KeeperException.Code.get((int)rc);
            _log.debug("{}: getChildren returned {}: {}", new Object[]{path, code, children});
            boolean init = (Boolean)ctx;
            String property = ZooKeeperChildrenDataPublisher.this.getPropertyForPath(path);
            switch (code) {
                case OK: {
                    if (init) {
                        ZooKeeperChildrenDataPublisher.this._zkDataWatcher.initialize(path, children);
                        break;
                    }
                    ZooKeeperChildrenDataPublisher.this._zkDataWatcher.processNewChildren(path, children);
                    break;
                }
                case NONODE: {
                    _log.debug("{}: node is not present, calling exists", (Object)path);
                    ZooKeeperChildrenDataPublisher.this._zk.exists(path, this, (AsyncCallback.StatCallback)this, (Object)false);
                    if (init) {
                        ZooKeeperChildrenDataPublisher.this._eventBus.publishInitialize(property, null);
                        _log.debug("{}: published init", (Object)path);
                        break;
                    }
                    ZooKeeperChildrenDataPublisher.this._eventBus.publishRemove(property);
                    _log.debug("{}: published remove", (Object)path);
                    break;
                }
                default: {
                    _log.error("getChildren: unexpected error: {}: {}", (Object)code, (Object)path);
                }
            }
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            KeeperException.Code code = KeeperException.Code.get((int)rc);
            _log.debug("{}: exists returned {}", (Object)path, (Object)code);
            switch (code) {
                case OK: {
                    _log.debug("{}: calling getChildren", (Object)path);
                    ZooKeeperChildrenDataPublisher.this._zk.getChildren(path, (Watcher)this, (AsyncCallback.ChildrenCallback)this, (Object)false);
                    break;
                }
                case NONODE: {
                    _log.debug("{}: set exists watch", (Object)path);
                    break;
                }
                default: {
                    _log.error("exists: unexpected error: {}: {}", (Object)code, (Object)path);
                }
            }
        }
    }

    private class ZKDataWatcher
    extends ZooKeeperStore.ZKStoreWatcher
    implements AsyncCallback.DataCallback {
        private volatile int _initialCount;
        private volatile Map<String, V> _childMap;

        private ZKDataWatcher() {
            super(ZooKeeperChildrenDataPublisher.this);
            this._childMap = new HashMap();
        }

        private void initialize(String path, List<String> children) {
            this._initialCount = children.size();
            this._childMap = new HashMap();
            for (String child : children) {
                String childPath = path + "/" + child;
                this.addWatch(ZooKeeperChildrenDataPublisher.this.getPropertyForPath(childPath));
                ZooKeeperChildrenDataPublisher.this._zk.getData(childPath, this, (AsyncCallback.DataCallback)this, (Object)true);
            }
        }

        private void processNewChildren(String path, List<String> children) {
            for (String child : children) {
                String childPath = path + "/" + child;
                if (this.containsWatch(ZooKeeperChildrenDataPublisher.this.getPropertyForPath(childPath))) continue;
                this.addWatch(ZooKeeperChildrenDataPublisher.this.getPropertyForPath(childPath));
                ZooKeeperChildrenDataPublisher.this._zk.getData(childPath, this, (AsyncCallback.DataCallback)this, (Object)false);
            }
        }

        private String getPropertyToPublish(String inputPath) {
            Matcher m = PATH_PATTERN.matcher(inputPath);
            if (m.matches()) {
                String parent = m.group(1);
                String child = m.group(2);
                if (parent != null && !parent.isEmpty() && child != null && !child.isEmpty()) {
                    return ZooKeeperChildrenDataPublisher.this.getPropertyForPath(parent);
                }
            }
            return null;
        }

        public void processResult(int rc, String path, Object ctx, byte[] bytes, Stat stat) {
            KeeperException.Code code = KeeperException.Code.get((int)rc);
            _log.debug("{}: getData returned {}", (Object)path, (Object)code);
            String propToPublish = this.getPropertyToPublish(path);
            boolean init = (Boolean)ctx;
            if (init) {
                --this._initialCount;
            }
            switch (code) {
                case OK: {
                    try {
                        Object value = ZooKeeperChildrenDataPublisher.this._childSerializer.fromBytes(bytes);
                        this._childMap.put(ZooKeeperChildrenDataPublisher.this.getPropertyForPath(path), value);
                        if (init) {
                            if (this._initialCount != 0) break;
                            ZooKeeperChildrenDataPublisher.this._eventBus.publishInitialize(propToPublish, new HashMap(this._childMap));
                            _log.debug("{}: published initialize", (Object)propToPublish);
                            break;
                        }
                        ZooKeeperChildrenDataPublisher.this._eventBus.publishAdd(propToPublish, new HashMap(this._childMap));
                        _log.debug("{}: published add", (Object)propToPublish);
                    }
                    catch (PropertySerializationException e) {
                        _log.error("Failed to getData for path " + path, (Throwable)e);
                        if (!init) break;
                        this._initialCount = 0;
                        ZooKeeperChildrenDataPublisher.this._eventBus.publishInitialize(propToPublish, null);
                    }
                    break;
                }
                case NONODE: {
                    this.cancelWatch(ZooKeeperChildrenDataPublisher.this.getPropertyForPath(path));
                    this._childMap.remove(ZooKeeperChildrenDataPublisher.this.getPropertyForPath(path));
                    if (init) {
                        if (this._initialCount != 0) break;
                        ZooKeeperChildrenDataPublisher.this._eventBus.publishInitialize(propToPublish, new HashMap(this._childMap));
                        _log.debug("{}: published initialize", (Object)propToPublish);
                        break;
                    }
                    ZooKeeperChildrenDataPublisher.this._eventBus.publishAdd(propToPublish, new HashMap(this._childMap));
                    _log.debug("{}: published add", (Object)propToPublish);
                    break;
                }
                default: {
                    _log.error("getData: unexpected error: {}: {}", (Object)code, (Object)path);
                    if (!init) break;
                    this._initialCount = 0;
                    ZooKeeperChildrenDataPublisher.this._eventBus.publishInitialize(propToPublish, null);
                }
            }
        }

        @Override
        public void processWatch(String propertyName, WatchedEvent watchedEvent) {
            ZooKeeperChildrenDataPublisher.this._zk.getData(ZooKeeperChildrenDataPublisher.this.getPath(propertyName), this, (AsyncCallback.DataCallback)this, (Object)false);
        }
    }
}

