/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.toggling;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.d2.discovery.stores.PropertyStore;
import com.linkedin.d2.discovery.stores.PropertyStoreException;
import com.linkedin.d2.discovery.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TogglingStore<T>
implements PropertyStore<T> {
    private static final Logger _log = LoggerFactory.getLogger(TogglingStore.class);
    private final PropertyStore<T> _store;
    private volatile boolean _enabled;

    public TogglingStore(PropertyStore<T> store) {
        this._store = store;
        this.setEnabled(store != null);
    }

    public PropertyStore<T> getStore() {
        return this._store;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        LogUtil.info(_log, this._store, " toggled, where enabled = ", enabled);
        this._enabled = enabled;
    }

    @Override
    public T get(String listenTo) throws PropertyStoreException {
        if (this._enabled) {
            return this._store.get(listenTo);
        }
        LogUtil.warn(_log, this._store, " ignored get request: ", listenTo);
        return null;
    }

    @Override
    public void put(String listenTo, T discoveryProperties) throws PropertyStoreException {
        if (this._enabled) {
            this._store.put(listenTo, discoveryProperties);
        } else {
            LogUtil.warn(_log, this._store, " ignored put request: ", listenTo);
        }
    }

    @Override
    public void remove(String listenTo) throws PropertyStoreException {
        if (this._enabled) {
            this._store.remove(listenTo);
        } else {
            LogUtil.warn(_log, this._store, " ignored remove request: ", listenTo);
        }
    }

    @Override
    public void start(Callback<None> callback) {
        this._store.start(callback);
    }

    @Override
    public void shutdown(PropertyEventThread.PropertyEventShutdownCallback callback) {
        if (this._enabled) {
            this._store.shutdown(callback);
        } else {
            LogUtil.warn(_log, this._store, " shutdown called on disabled store");
            callback.done();
        }
    }

    public String toString() {
        return "TogglingStore [_enabled=" + this._enabled + ", _store=" + this._store + "]";
    }
}

