/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.file;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.PropertySerializationException;
import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.d2.discovery.event.PropertyEventSubscriber;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.d2.discovery.stores.PropertyStore;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.d2.discovery.util.Stats;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStore<T>
implements PropertyStore<T>,
PropertyEventSubscriber<T> {
    private static final Logger _log = LoggerFactory.getLogger(FileStore.class);
    private static final String TMP_FILE_PREFIX = "d2-";
    private final String _path;
    private final String _extension;
    private final PropertySerializer<T> _serializer;
    private final Stats _getStats = new Stats(60000L);
    private final Stats _putStats = new Stats(60000L);
    private final Stats _removeStats = new Stats(60000L);

    public FileStore(String path, String extension, PropertySerializer<T> serializer) {
        this._path = path;
        this._extension = extension;
        this._serializer = serializer;
        File file = new File(this._path);
        if (!file.exists() && !file.mkdirs()) {
            LogUtil.error(_log, "unable to create file path: " + this._path);
        }
    }

    @Override
    public void start(Callback<None> callback) {
        File file = new File(this._path);
        if (!file.exists()) {
            if (!file.mkdirs()) {
                callback.onError((Throwable)new IOException("unable to create file path: " + this._path));
            } else {
                callback.onSuccess((Object)None.none());
            }
        }
    }

    @Override
    public T get(String listenTo) {
        this._getStats.inc();
        File file = this.getFile(listenTo);
        if (file.exists()) {
            try {
                byte[] content = new byte[(int)file.length()];
                int offset = 0;
                int read = 0;
                int length = (int)file.length();
                FileInputStream inputStream = new FileInputStream(file);
                while ((read = inputStream.read(content, offset, length - offset)) > 0) {
                    offset += read;
                }
                inputStream.close();
                return this._serializer.fromBytes(content);
            }
            catch (IOException e) {
                _log.error("Error reading file: " + file.getAbsolutePath(), (Throwable)e);
            }
            catch (PropertySerializationException e) {
                _log.error("Error deserializing property " + listenTo + " for file " + file.getAbsolutePath(), (Throwable)e);
            }
        }
        LogUtil.warn(_log, "file didn't exist on get: ", file);
        return null;
    }

    @Override
    public void put(String listenTo, T discoveryProperties) {
        if (discoveryProperties == null) {
            LogUtil.warn(_log, "received a null property for resource ", listenTo, " received a null property");
        } else {
            this._putStats.inc();
            File file = this.getFile(listenTo);
            try {
                File tempFile = this.getTempFile(listenTo);
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                outputStream.write(this._serializer.toBytes(discoveryProperties));
                outputStream.close();
                if (!tempFile.renameTo(file)) {
                    LogUtil.error(_log, "unable to move temp file ", tempFile, " to ", file);
                }
            }
            catch (FileNotFoundException e) {
                LogUtil.error(_log, "unable to find file on put: ", file);
            }
            catch (IOException e) {
                LogUtil.error(_log, "unable to read file on put: ", file);
            }
        }
    }

    @Override
    public void remove(String listenTo) {
        this._removeStats.inc();
        File file = this.getFile(listenTo);
        if (file.exists()) {
            file.delete();
        } else {
            LogUtil.warn(_log, "file didn't exist on remove: ", file);
        }
    }

    @Override
    public void onAdd(String propertyName, T propertyValue) {
        this.put(propertyName, propertyValue);
    }

    @Override
    public void onInitialize(String propertyName, T propertyValue) {
        this.put(propertyName, propertyValue);
    }

    @Override
    public void onRemove(String propertyName) {
        this.remove(propertyName);
    }

    private File getFile(String listenTo) {
        return new File(this._path + File.separatorChar + listenTo + this._extension);
    }

    private File getTempFile(String listenTo) throws IOException {
        return File.createTempFile(TMP_FILE_PREFIX + listenTo, "tmp", new File(this._path));
    }

    @Override
    public void shutdown(PropertyEventThread.PropertyEventShutdownCallback shutdown) {
        LogUtil.info(_log, "shutting down");
        shutdown.done();
    }

    public String getPath() {
        return this._path;
    }

    public PropertySerializer<T> getSerializer() {
        return this._serializer;
    }

    public long getGetCount() {
        return this._getStats.getCount();
    }

    public long getPutCount() {
        return this._putStats.getCount();
    }

    public long getRemoveCount() {
        return this._removeStats.getCount();
    }
}

