/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.partitions;

import com.linkedin.d2.balancer.properties.RangeBasedPartitionProperties;
import com.linkedin.d2.balancer.util.partitions.AbstractPartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeBasedPartitionAccessor
extends AbstractPartitionAccessor {
    private final RangeBasedPartitionProperties _properties;
    private static final Logger _log = LoggerFactory.getLogger(RangeBasedPartitionAccessor.class);

    public RangeBasedPartitionAccessor(RangeBasedPartitionProperties properties) {
        super(properties.getPartitionKeyRegex(), properties.getPartitionCount() - 1);
        this._properties = properties;
    }

    @Override
    public int getPartitionId(String key) throws PartitionAccessException {
        try {
            int partitionCount;
            long longKey = Long.parseLong(key);
            if (longKey < 0L) {
                throw new PartitionAccessException("Partition key needs to be non negative in range based partitions: " + longKey);
            }
            int partitionId = (int)((longKey - this._properties.getKeyRangeStart()) / this._properties.getPartitionSize());
            if (partitionId >= (partitionCount = this._properties.getPartitionCount()) || partitionId < 0) {
                throw new PartitionAccessException("Partition id out of range: " + partitionId + ", partitionId range is [0, " + (partitionCount - 1) + "]");
            }
            _log.debug("Getting partitionId for key ({}): {}", (Object)key, (Object)partitionId);
            return partitionId;
        }
        catch (NumberFormatException e) {
            throw new PartitionAccessException("Using RangeBasedPartitions. Keys should be long values, but failed to parse key to long: " + key);
        }
    }
}

