/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.LoadBalancer;
import com.linkedin.d2.balancer.ServiceUnavailableException;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.util.ClientFactoryProvider;
import com.linkedin.d2.balancer.util.HostToKeyMapper;
import com.linkedin.d2.balancer.util.MapKeyResult;
import com.linkedin.d2.balancer.util.hashing.HashRingProvider;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.PartitionInfoProvider;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.d2.discovery.stores.toggling.TogglingPublisher;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import java.net.URI;
import java.util.Collection;
import java.util.Map;

public class TogglingLoadBalancer
implements LoadBalancer,
HashRingProvider,
ClientFactoryProvider,
PartitionInfoProvider {
    private final LoadBalancer _balancer;
    private final TogglingPublisher<?>[] _toggles;

    public TogglingLoadBalancer(LoadBalancer balancer, TogglingPublisher<?> ... toggles) {
        this._balancer = balancer;
        this._toggles = toggles;
    }

    public void enablePrimary(Callback<None> callback) {
        Callback multiCallback = Callbacks.countDown(callback, (int)this._toggles.length);
        for (TogglingPublisher<?> toggle : this._toggles) {
            toggle.enablePrimary((Callback<None>)multiCallback);
        }
    }

    public void enableBackup(Callback<None> callback) {
        Callback multiCallback = Callbacks.countDown(callback, (int)this._toggles.length);
        for (TogglingPublisher<?> toggle : this._toggles) {
            toggle.enableBackup((Callback<None>)multiCallback);
        }
    }

    @Override
    public void start(Callback<None> callback) {
        this._balancer.start(callback);
    }

    @Override
    public void shutdown(PropertyEventThread.PropertyEventShutdownCallback shutdown) {
        this._balancer.shutdown(shutdown);
    }

    @Override
    public ServiceProperties getLoadBalancedServiceProperties(String serviceName) throws ServiceUnavailableException {
        return this._balancer.getLoadBalancedServiceProperties(serviceName);
    }

    @Override
    public TransportClient getClient(Request request, RequestContext requestContext) throws ServiceUnavailableException {
        return this._balancer.getClient(request, requestContext);
    }

    @Override
    public <K> MapKeyResult<Ring<URI>, K> getRings(URI serviceUri, Iterable<K> keys) throws ServiceUnavailableException {
        this.checkLoadBalancer();
        return ((HashRingProvider)((Object)this._balancer)).getRings(serviceUri, keys);
    }

    @Override
    public Map<Integer, Ring<URI>> getRings(URI serviceUri) throws ServiceUnavailableException {
        this.checkLoadBalancer();
        return ((HashRingProvider)((Object)this._balancer)).getRings(serviceUri);
    }

    @Override
    public <K> HostToKeyMapper<K> getPartitionInformation(URI serviceUri, Collection<K> keys, int limitHostPerPartition, int hash) throws ServiceUnavailableException {
        this.checkPartitionInfoProvider();
        return ((PartitionInfoProvider)((Object)this._balancer)).getPartitionInformation(serviceUri, keys, limitHostPerPartition, hash);
    }

    @Override
    public PartitionAccessor getPartitionAccessor(URI serviceUri) throws ServiceUnavailableException {
        this.checkPartitionInfoProvider();
        return ((PartitionInfoProvider)((Object)this._balancer)).getPartitionAccessor(serviceUri);
    }

    private void checkLoadBalancer() {
        if (this._balancer == null || !(this._balancer instanceof HashRingProvider)) {
            throw new IllegalStateException("No HashRingProvider available to TogglingLoadBalancer - this could be because the load balancer is not yet initialized, or because it has been configured with strategies that do not support consistent hashing.");
        }
    }

    private void checkPartitionInfoProvider() {
        if (this._balancer == null || !(this._balancer instanceof PartitionInfoProvider)) {
            throw new IllegalStateException("No PartitionInfoProvider available to TogglingLoadBalancer - this could be because the load balancer is not yet initialized, or because it has been configured with strategies that do not support consistent hashing.");
        }
    }

    @Override
    public TransportClientFactory getClientFactory(String scheme) {
        if (this._balancer == null || !(this._balancer instanceof ClientFactoryProvider)) {
            throw new IllegalStateException("No ClientFactoryProvider available to TogglingLoadBalancer - this could be because the load balancer is not yet initialized, or because it has beenconfigured with a LoadBalancer which does notsupport obtaining client factories");
        }
        return ((ClientFactoryProvider)((Object)this._balancer)).getClientFactory(scheme);
    }
}

