/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MapKeyResult<T, K> {
    private final Map<T, Collection<K>> _mapResult;
    private final Collection<UnmappedKey<K>> _unmappedKeys;

    public MapKeyResult(Map<T, Collection<K>> mapResult, Collection<UnmappedKey<K>> unMappedKeys) {
        HashMap<T, Collection<K>> mapResultTmp = new HashMap<T, Collection<K>>(mapResult.size() * 2);
        for (Map.Entry<T, Collection<K>> entry : mapResult.entrySet()) {
            mapResultTmp.put(entry.getKey(), Collections.unmodifiableCollection(entry.getValue()));
        }
        this._mapResult = Collections.unmodifiableMap(mapResultTmp);
        this._unmappedKeys = Collections.unmodifiableCollection(unMappedKeys);
    }

    public Map<T, Collection<K>> getMapResult() {
        return this._mapResult;
    }

    public Collection<UnmappedKey<K>> getUnmappedKeys() {
        return this._unmappedKeys;
    }

    public static class UnmappedKey<K> {
        private final K _key;
        private final ErrorType _errorType;

        public UnmappedKey(K key, ErrorType errorType) {
            this._key = key;
            this._errorType = errorType;
        }

        public K getKey() {
            return this._key;
        }

        public ErrorType getErrorType() {
            return this._errorType;
        }

        public int hashCode() {
            int hashCode = this._key == null ? 1 : this._key.hashCode() * 31;
            hashCode = 31 * hashCode * (this._errorType == null ? 1 : this._errorType.hashCode());
            return hashCode;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof UnmappedKey)) {
                return false;
            }
            UnmappedKey u = (UnmappedKey)o;
            return this._errorType.equals((Object)u._errorType) && this._key.equals(u._key);
        }
    }

    public static enum ErrorType {
        FAIL_TO_FIND_PARTITION,
        NO_HOST_AVAILABLE_IN_PARTITION;

    }
}

