/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.properties.util.PropertyUtil;
import com.linkedin.d2.balancer.util.JacksonUtil;
import com.linkedin.d2.discovery.PropertyBuilder;
import com.linkedin.d2.discovery.PropertySerializationException;
import com.linkedin.d2.discovery.PropertySerializer;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriPropertiesJsonSerializer
implements PropertySerializer<UriProperties>,
PropertyBuilder<UriProperties> {
    private static final Logger _log = LoggerFactory.getLogger(UriPropertiesJsonSerializer.class);

    @Override
    public byte[] toBytes(UriProperties property) {
        try {
            Map<URI, Map<Integer, PartitionData>> partitionDesc = property.getPartitionDesc();
            final HashMap<URI, Double> weights = new HashMap<URI, Double>(partitionDesc.size() * 2);
            boolean isPartitioned = false;
            for (Map.Entry<URI, Map<Integer, PartitionData>> entry : partitionDesc.entrySet()) {
                Map<Integer, PartitionData> partitionDataMap = entry.getValue();
                if (partitionDataMap.size() > 1 || !partitionDataMap.containsKey(0)) {
                    isPartitioned = true;
                    break;
                }
                weights.put(entry.getKey(), partitionDataMap.get(0).getWeight());
            }
            UriProperties propertyToSerialize = isPartitioned ? property : new UriProperties(property.getClusterName(), partitionDesc, property.getUriSpecificProperties()){

                public Map<URI, Double> getWeights() {
                    return weights;
                }
            };
            return JacksonUtil.getObjectMapper().writeValueAsString((Object)propertyToSerialize).getBytes("UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public UriProperties fromBytes(byte[] bytes) throws PropertySerializationException {
        try {
            Map untyped = (Map)JacksonUtil.getObjectMapper().readValue(new String(bytes, "UTF-8"), HashMap.class);
            return this.fromMap(untyped);
        }
        catch (Exception e) {
            throw new PropertySerializationException(e);
        }
    }

    @Override
    public UriProperties fromMap(Map<String, Object> map) {
        Map<URI, Map<String, Object>> applicationProperties;
        String clusterName = PropertyUtil.checkAndGetValue(map, "clusterName", String.class, "UriProperties");
        String applicationPropertiesKey = "uriSpecificProperties";
        if (map.containsKey("uriSpecificProperties")) {
            applicationProperties = new HashMap();
            Map storedApplicationProperties = PropertyUtil.checkAndGetValue(map, "uriSpecificProperties", HashMap.class, "UriProperties");
            for (Map.Entry entry : storedApplicationProperties.entrySet()) {
                applicationProperties.put(URI.create((String)entry.getKey()), (Map<String, Object>)entry.getValue());
            }
        } else {
            applicationProperties = Collections.emptyMap();
        }
        HashMap<URI, Map<Integer, PartitionData>> partitionDesc = new HashMap<URI, Map<Integer, PartitionData>>();
        Map descMap = (Map)map.get("partitionDesc");
        if (descMap != null) {
            for (Map.Entry entry : descMap.entrySet()) {
                URI uri = URI.create((String)entry.getKey());
                Map partitionMap = (Map)entry.getValue();
                HashMap<Integer, PartitionData> partitionDataMap = new HashMap<Integer, PartitionData>(partitionMap.size() * 2);
                for (Map.Entry partitionEntry : partitionMap.entrySet()) {
                    Map partitionEntryValue = (Map)partitionEntry.getValue();
                    partitionDataMap.put(PropertyUtil.parseInt("partitionId", (String)partitionEntry.getKey()), new PartitionData(PropertyUtil.checkAndGetValue(partitionEntryValue, "weight", Number.class, clusterName).doubleValue()));
                }
                partitionDesc.put(uri, partitionDataMap);
            }
        }
        Map map2 = (Map)map.get("weights");
        HashMap partitionDescFromWeights = new HashMap();
        if (map2 != null) {
            for (Map.Entry weightEntry : map2.entrySet()) {
                String uriStr = (String)weightEntry.getKey();
                URI uri = URI.create(uriStr);
                HashMap<Integer, PartitionData> partitionDataMap = new HashMap<Integer, PartitionData>(2);
                partitionDataMap.put(0, new PartitionData(PropertyUtil.checkAndGetValue(map2, uriStr, Number.class, clusterName).doubleValue()));
                partitionDescFromWeights.put(uri, partitionDataMap);
            }
        }
        if (!(partitionDesc.isEmpty() || partitionDescFromWeights.isEmpty() || partitionDesc.equals(partitionDescFromWeights))) {
            _log.error("Inconsistency detected between partitionDesc and weights", partitionDesc, (Object)map2);
        }
        if (partitionDesc.isEmpty()) {
            partitionDesc = partitionDescFromWeights;
        }
        return new UriProperties(clusterName, partitionDesc, applicationProperties);
    }
}

