/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clients;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.LoadBalancerClient;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.util.LoadBalancerUtil;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.jersey.api.uri.UriBuilder;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamRequestBuilder;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteClient
implements LoadBalancerClient {
    private static final Logger _log = LoggerFactory.getLogger(TrackerClient.class);
    private final String _serviceName;
    private final URI _uri;
    private final TransportClient _wrappedClient;

    public RewriteClient(String serviceName, URI uri, TransportClient wrappedClient) {
        this._serviceName = serviceName;
        this._uri = uri;
        this._wrappedClient = wrappedClient;
        LogUtil.debug(_log, "created rewrite client: ", this);
    }

    public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
        this._wrappedClient.restRequest(this.rewriteRequest(request), requestContext, wireAttrs, callback);
    }

    public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
        this._wrappedClient.streamRequest(this.rewriteRequest(request), requestContext, wireAttrs, callback);
    }

    public void shutdown(Callback<None> callback) {
        this._wrappedClient.shutdown(callback);
    }

    public TransportClient getWrappedClient() {
        return this._wrappedClient;
    }

    private StreamRequest rewriteRequest(StreamRequest req) {
        return ((StreamRequestBuilder)req.builder().setURI(this.rewriteUri(req.getURI()))).build(req.getEntityStream());
    }

    private RestRequest rewriteRequest(RestRequest req) {
        return ((RestRequestBuilder)req.builder().setURI(this.rewriteUri(req.getURI()))).build();
    }

    private URI rewriteUri(URI uri) {
        assert (this._serviceName.equals(LoadBalancerUtil.getServiceNameFromUri(uri)));
        String path = LoadBalancerUtil.getRawPathFromUri(uri);
        UriBuilder builder = UriBuilder.fromUri((URI)this._uri);
        if (path != null) {
            builder.path(path);
        }
        builder.replaceQuery(uri.getRawQuery());
        builder.fragment(uri.getRawFragment());
        URI rewrittenUri = builder.build(new Object[0]);
        LogUtil.debug(_log, "rewrite uri ", uri, " -> ", rewrittenUri);
        return rewrittenUri;
    }

    @Override
    public URI getUri() {
        return this._uri;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public String toString() {
        return "RewriteClient [_serviceName=" + this._serviceName + ", _uri=" + this._uri + ", _wrappedClient=" + this._wrappedClient + "]";
    }
}

