/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.google;

import com.google.api.services.drive.Drive;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.extractor.extract.google.GoogleDriveFileSystem;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelperException;
import org.apache.gobblin.source.extractor.filebased.TimestampAwareFileBasedHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleDriveFsHelper
implements TimestampAwareFileBasedHelper {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleDriveFsHelper.class);
    static final String BUFFER_SIZE_BYTE = "source.google.buffer_size_bytes";
    private final FileSystem fileSystem;
    private final Closer closer;
    private final Optional<Integer> bufferSizeByte;

    public GoogleDriveFsHelper(State state, Drive client) {
        this(state, client, Closer.create());
    }

    @VisibleForTesting
    GoogleDriveFsHelper(State state, Drive client, Closer closer) {
        this.closer = closer;
        this.fileSystem = (FileSystem)this.closer.register((Closeable)((Object)new GoogleDriveFileSystem(client)));
        this.bufferSizeByte = state.contains(BUFFER_SIZE_BYTE) ? Optional.of((Object)state.getPropAsInt(BUFFER_SIZE_BYTE)) : Optional.absent();
    }

    public long getFileSize(String fileId) throws FileBasedHelperException {
        Preconditions.checkNotNull((Object)fileId, (Object)"fileId is required");
        Path p = new Path(fileId);
        try {
            FileStatus status = this.fileSystem.getFileStatus(p);
            return status.getLen();
        }
        catch (IOException e) {
            throw new FileBasedHelperException("Failed to get metadata on " + fileId, (Exception)e);
        }
    }

    public void connect() throws FileBasedHelperException {
    }

    public void close() throws IOException {
        this.closer.close();
    }

    public List<String> ls(String folderId) throws FileBasedHelperException {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)folderId)) {
            folderId = "/";
        }
        Path p = new Path(folderId);
        FileStatus[] statusList = null;
        try {
            statusList = this.fileSystem.listStatus(p);
        }
        catch (FileNotFoundException e) {
            return result;
        }
        catch (IOException e) {
            throw new FileBasedHelperException("Falied to list status on path " + p + ", folderID: " + folderId, (Exception)e);
        }
        for (FileStatus status : statusList) {
            if (status.isDirectory()) {
                result.addAll(this.ls(GoogleDriveFileSystem.toFileId(status.getPath())));
                continue;
            }
            result.add(GoogleDriveFileSystem.toFileId(status.getPath()));
        }
        return result;
    }

    public InputStream getFileStream(String fileId) throws FileBasedHelperException {
        Preconditions.checkNotNull((Object)fileId, (Object)"fileId is required");
        Path p = new Path(fileId);
        try {
            if (this.bufferSizeByte.isPresent()) {
                return this.fileSystem.open(p, ((Integer)this.bufferSizeByte.get()).intValue());
            }
            return this.fileSystem.open(p);
        }
        catch (IOException e) {
            throw new FileBasedHelperException("Failed to open files stream on path: " + p + " , fileId: " + fileId, (Exception)e);
        }
    }

    public void deleteFile(String fileId) throws IOException {
        Preconditions.checkNotNull((Object)fileId, (Object)"fileId is required");
        Path p = new Path(fileId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting path: " + p + " , fileId: " + fileId);
        }
        this.fileSystem.delete(p, true);
    }

    public long getFileMTime(String fileId) throws FileBasedHelperException {
        Preconditions.checkNotNull((Object)fileId, (Object)"fileId is required");
        Path p = new Path(fileId);
        try {
            FileStatus status = this.fileSystem.getFileStatus(p);
            return status.getModificationTime();
        }
        catch (IOException e) {
            throw new FileBasedHelperException("Failed to retrieve getModificationTime on path: " + p + " , fileId: " + fileId, (Exception)e);
        }
    }
}

