/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google.webmaster;

import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gobblin.ingestion.google.webmaster.UrlTrie;
import org.apache.gobblin.ingestion.google.webmaster.UrlTrieNode;

public class UrlTriePostOrderIterator
implements Iterator<Pair<String, UrlTrieNode>> {
    private final int _groupSize;
    private final StringBuilder _currentPrefixSb;
    private Deque<UrlTrieNode> _unprocessed = new ArrayDeque<UrlTrieNode>();
    private UrlTrieNode _currentNode;
    private UrlTrieNode _lastVisited = null;
    private UrlTrieNode _toReturn;

    public UrlTriePostOrderIterator(UrlTrie trie, int stoppingSize) {
        Preconditions.checkArgument((stoppingSize > 0 ? 1 : 0) != 0);
        this._currentNode = trie.getRoot();
        String prefix = trie.getPrefix();
        this._currentPrefixSb = new StringBuilder();
        if (prefix != null) {
            this._currentPrefixSb.append(prefix);
        }
        this._groupSize = stoppingSize;
    }

    @Override
    public boolean hasNext() {
        if (this._toReturn != null) {
            return true;
        }
        while (!this._unprocessed.isEmpty() || !this.isStoppingNode(this._currentNode)) {
            if (!this.isStoppingNode(this._currentNode)) {
                this._unprocessed.push(this._currentNode);
                this._currentPrefixSb.append(this._currentNode.getValue());
                Map.Entry<Character, UrlTrieNode> next = this._currentNode.children.firstEntry();
                if (next == null) {
                    this._currentNode = null;
                    continue;
                }
                this._currentNode = next.getValue();
                continue;
            }
            UrlTrieNode peekNode = this._unprocessed.peek();
            if (this._currentNode != null || peekNode.children.isEmpty() || peekNode.children.lastEntry().getValue() == this._lastVisited) {
                if (this._currentNode != null) {
                    this._toReturn = this._currentNode;
                } else {
                    this._toReturn = this._unprocessed.pop();
                    this._currentPrefixSb.setLength(this._currentPrefixSb.length() - 1);
                }
                UrlTrieNode parent = this._unprocessed.peek();
                if (parent == null) {
                    return true;
                }
                Map.Entry<Character, UrlTrieNode> sibling = parent.children.higherEntry(this._toReturn.getValue());
                this._currentNode = sibling == null ? null : sibling.getValue();
                return true;
            }
            this._currentNode = peekNode;
        }
        if (this._lastVisited == null && this._currentNode.getSize() > 0) {
            this._toReturn = this._currentNode;
            return true;
        }
        return false;
    }

    private boolean isStoppingNode(UrlTrieNode node) {
        return node == null || node.getSize() <= this._groupSize;
    }

    @Override
    public Pair<String, UrlTrieNode> next() {
        if (this.hasNext()) {
            this._lastVisited = this._toReturn;
            this._toReturn = null;
            return Pair.of((Object)(this._currentPrefixSb.toString() + this._lastVisited.getValue()), (Object)this._lastVisited);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

