/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google.webmaster;

import org.slf4j.Logger;

class ProgressReporter {
    private volatile int checkPointCount = 0;
    private volatile int totalProcessed = 0;
    private final Logger _log;
    private final int _total;
    private final int _checkPoint;

    ProgressReporter(Logger log, int total) {
        this(log, total, 20);
    }

    private ProgressReporter(Logger log, int total, int frequency) {
        this._log = log;
        this._total = total;
        this._checkPoint = (int)Math.max(1.0, Math.ceil(1.0 * (double)total / (double)frequency));
    }

    public synchronized void report(int progress, String country) {
        this.checkPointCount += progress;
        if (this.checkPointCount >= this._checkPoint) {
            this.totalProcessed += this.checkPointCount;
            this.checkPointCount = 0;
            this._log.info(String.format("Current progress: %d of %d processed for %s", this.totalProcessed, this._total, country));
        }
    }
}

