/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaJsonDeserializer;
import java.io.IOException;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.kafka.client.ByteArrayBasedKafkaRecord;
import org.apache.gobblin.metrics.kafka.KafkaSchemaRegistry;
import org.apache.gobblin.metrics.kafka.SchemaRegistryException;
import org.apache.gobblin.source.extractor.extract.kafka.ConfluentKafkaSchemaRegistry;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaExtractor;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaGsonDeserializer;
import org.apache.gobblin.source.extractor.extract.kafka.SimpleKafkaSchemaRegistry;
import org.apache.gobblin.util.AvroUtils;
import org.apache.gobblin.util.PropertiesUtils;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;

@Alias(value="DESERIALIZER")
public class KafkaDeserializerExtractor
extends KafkaExtractor<Object, Object> {
    public static final String KAFKA_DESERIALIZER_TYPE = "kafka.deserializer.type";
    private static final String CONFLUENT_SCHEMA_REGISTRY_URL = "schema.registry.url";
    private final Deserializer<?> kafkaDeserializer;
    private final KafkaSchemaRegistry<?, ?> kafkaSchemaRegistry;
    private final Schema latestSchema;

    public KafkaDeserializerExtractor(WorkUnitState state) throws ReflectiveOperationException {
        this(state, KafkaDeserializerExtractor.getDeserializerType(state.getProperties()));
    }

    private KafkaDeserializerExtractor(WorkUnitState state, Optional<Deserializers> deserializerType) throws ReflectiveOperationException {
        this(state, deserializerType, KafkaDeserializerExtractor.getDeserializer(KafkaDeserializerExtractor.getProps(state), deserializerType), KafkaDeserializerExtractor.getKafkaSchemaRegistry(KafkaDeserializerExtractor.getProps(state)));
    }

    @VisibleForTesting
    KafkaDeserializerExtractor(WorkUnitState state, Optional<Deserializers> deserializerType, Deserializer<?> kafkaDeserializer, KafkaSchemaRegistry<?, ?> kafkaSchemaRegistry) {
        super(state);
        this.kafkaDeserializer = kafkaDeserializer;
        this.kafkaSchemaRegistry = kafkaSchemaRegistry;
        this.latestSchema = deserializerType.equals((Object)Optional.of((Object)((Object)Deserializers.CONFLUENT_AVRO))) ? (Schema)this.getSchema() : null;
    }

    protected Object decodeRecord(ByteArrayBasedKafkaRecord messageAndOffset) throws IOException {
        Object deserialized = this.kafkaDeserializer.deserialize(this.topicName, messageAndOffset.getMessageBytes());
        return this.latestSchema == null ? deserialized : AvroUtils.convertRecordSchema((GenericRecord)((GenericRecord)deserialized), (Schema)this.latestSchema);
    }

    public Object getSchema() {
        try {
            return this.kafkaSchemaRegistry.getLatestSchemaByTopic(this.topicName);
        }
        catch (SchemaRegistryException e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<Deserializers> getDeserializerType(Properties props) {
        Preconditions.checkArgument((boolean)props.containsKey(KAFKA_DESERIALIZER_TYPE), (Object)"Missing required property kafka.deserializer.type");
        return Enums.getIfPresent(Deserializers.class, (String)props.getProperty(KAFKA_DESERIALIZER_TYPE).toUpperCase());
    }

    private static Deserializer<?> getDeserializer(Properties props, Optional<Deserializers> deserializerType) throws ReflectiveOperationException {
        Deserializer deserializer = deserializerType.isPresent() ? (Deserializer)ConstructorUtils.invokeConstructor(((Deserializers)((Object)deserializerType.get())).getDeserializerClass(), (Object[])new Object[0]) : (Deserializer)Deserializer.class.cast(ConstructorUtils.invokeConstructor(Class.forName(props.getProperty(KAFKA_DESERIALIZER_TYPE)), (Object[])new Object[0]));
        deserializer.configure(PropertiesUtils.propsToStringKeyMap((Properties)props), false);
        return deserializer;
    }

    private static KafkaSchemaRegistry<?, ?> getKafkaSchemaRegistry(Properties props) throws ReflectiveOperationException {
        Optional deserializerType = Enums.getIfPresent(Deserializers.class, (String)props.getProperty(KAFKA_DESERIALIZER_TYPE).toUpperCase());
        if (deserializerType.isPresent()) {
            return (KafkaSchemaRegistry)ConstructorUtils.invokeConstructor(((Deserializers)((Object)deserializerType.get())).getSchemaRegistryClass(), (Object[])new Object[]{props});
        }
        if (props.containsKey("kafka.schema.registry.class")) {
            return KafkaSchemaRegistry.get((Properties)props);
        }
        return new SimpleKafkaSchemaRegistry(props);
    }

    private static Properties getProps(WorkUnitState workUnitState) {
        Properties properties = workUnitState.getProperties();
        if (properties.containsKey("kafka.schema.registry.url")) {
            properties.setProperty(CONFLUENT_SCHEMA_REGISTRY_URL, properties.getProperty("kafka.schema.registry.url"));
        }
        return properties;
    }

    Deserializer<?> getKafkaDeserializer() {
        return this.kafkaDeserializer;
    }

    KafkaSchemaRegistry<?, ?> getKafkaSchemaRegistry() {
        return this.kafkaSchemaRegistry;
    }

    Schema getLatestSchema() {
        return this.latestSchema;
    }

    public static enum Deserializers {
        CONFLUENT_AVRO(KafkaAvroDeserializer.class, ConfluentKafkaSchemaRegistry.class),
        CONFLUENT_JSON(KafkaJsonDeserializer.class, SimpleKafkaSchemaRegistry.class),
        GSON(KafkaGsonDeserializer.class, SimpleKafkaSchemaRegistry.class),
        BYTE_ARRAY(ByteArrayDeserializer.class, SimpleKafkaSchemaRegistry.class),
        STRING(StringDeserializer.class, SimpleKafkaSchemaRegistry.class);

        private final Class<? extends Deserializer> deserializerClass;
        private final Class<? extends KafkaSchemaRegistry> schemaRegistryClass;

        private Deserializers(Class<? extends Deserializer> deserializerClass, Class<? extends KafkaSchemaRegistry> schemaRegistryClass) {
            this.deserializerClass = deserializerClass;
            this.schemaRegistryClass = schemaRegistryClass;
        }

        public Class<? extends Deserializer> getDeserializerClass() {
            return this.deserializerClass;
        }

        public Class<? extends KafkaSchemaRegistry> getSchemaRegistryClass() {
            return this.schemaRegistryClass;
        }
    }
}

