/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.kafka;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.gobblin.metrics.kafka.ProducerCloseable;
import org.apache.gobblin.metrics.kafka.Pusher;

public class KafkaPusher
implements Pusher<byte[]> {
    private final String topic;
    private final ProducerCloseable<String, byte[]> producer;
    private final Closer closer = Closer.create();

    public KafkaPusher(String brokers, String topic) {
        this.topic = topic;
        Properties props = new Properties();
        props.put("metadata.broker.list", brokers);
        props.put("serializer.class", "kafka.serializer.DefaultEncoder");
        props.put("request.required.acks", "1");
        ProducerConfig config = new ProducerConfig(props);
        this.producer = this.createProducer(config);
    }

    public void pushMessages(List<byte[]> messages) {
        List keyedMessages = Lists.transform(messages, (Function)new Function<byte[], KeyedMessage<String, byte[]>>(){

            @Nullable
            public KeyedMessage<String, byte[]> apply(byte[] bytes) {
                return new KeyedMessage(KafkaPusher.this.topic, (Object)bytes);
            }
        });
        this.producer.send(keyedMessages);
    }

    public void close() throws IOException {
        this.closer.close();
    }

    protected ProducerCloseable<String, byte[]> createProducer(ProducerConfig config) {
        return (ProducerCloseable)this.closer.register(new ProducerCloseable(config));
    }
}

