/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.kafka;

import com.google.common.base.Optional;
import com.google.common.io.Closer;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.metrics.kafka.Pusher;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class KafkaProducerPusher
implements Pusher<byte[]> {
    private final String topic;
    private final KafkaProducer<String, byte[]> producer;
    private final Closer closer = Closer.create();

    public KafkaProducerPusher(String brokers, String topic, Optional<Config> kafkaConfig) {
        this.topic = topic;
        Properties props = new Properties();
        props.put("bootstrap.servers", brokers);
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("value.serializer", ByteArraySerializer.class.getName());
        props.put("acks", "1");
        if (kafkaConfig.isPresent()) {
            props.putAll((Map<?, ?>)ConfigUtils.configToProperties((Config)((Config)kafkaConfig.get())));
        }
        this.producer = this.createProducer(props);
    }

    public KafkaProducerPusher(String brokers, String topic) {
        this(brokers, topic, (Optional<Config>)Optional.absent());
    }

    public void pushMessages(List<byte[]> messages) {
        for (byte[] message : messages) {
            this.producer.send(new ProducerRecord(this.topic, (Object)message));
        }
    }

    public void close() throws IOException {
        this.closer.close();
    }

    protected KafkaProducer<String, byte[]> createProducer(Properties props) {
        return (KafkaProducer)this.closer.register((Closeable)new KafkaProducer(props));
    }
}

