/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.objectstore;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.writer.objectstore.ObjectStoreClient;
import org.apache.gobblin.writer.objectstore.ObjectStoreOperation;
import org.apache.gobblin.writer.objectstore.response.DeleteResponse;

@Alpha
public class ObjectStoreDeleteOperation
extends ObjectStoreOperation<DeleteResponse> {
    private final byte[] objectId;
    private final Config deleteConfig;

    @Override
    public DeleteResponse execute(ObjectStoreClient objectStoreClient) throws IOException {
        objectStoreClient.delete(this.objectId, this.deleteConfig);
        return new DeleteResponse(202);
    }

    private ObjectStoreDeleteOperation(byte[] objectId, Config deleteConfig) {
        this.objectId = objectId;
        this.deleteConfig = deleteConfig;
    }

    public byte[] getObjectId() {
        return this.objectId;
    }

    public Config getDeleteConfig() {
        return this.deleteConfig;
    }

    public static class Builder {
        private byte[] objectId;
        private Config deleteConfig;

        public Builder withObjectId(byte[] objectId) {
            this.objectId = objectId;
            return this;
        }

        public Builder withDeleteConfig(Config deleteConfig) {
            this.deleteConfig = deleteConfig;
            return this;
        }

        public ObjectStoreDeleteOperation build() {
            Preconditions.checkArgument((this.objectId != null ? 1 : 0) != 0, (Object)"Object Id needs to be set");
            if (this.deleteConfig == null) {
                this.deleteConfig = ConfigFactory.empty();
            }
            return new ObjectStoreDeleteOperation(this.objectId, this.deleteConfig);
        }
    }
}

