/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.http;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.config.ConfigBuilder;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.http.HttpClientConfiguratorLoader;
import org.apache.gobblin.writer.Destination;
import org.apache.gobblin.writer.FluentDataWriterBuilder;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpWriterBuilder<S, D, B extends AbstractHttpWriterBuilder<S, D, B>>
extends FluentDataWriterBuilder<S, D, B> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHttpWriterBuilder.class);
    public static final String CONF_PREFIX = "gobblin.writer.http.";
    public static final String HTTP_CONN_MANAGER = "conn_mgr_type";
    public static final String POOLING_CONN_MANAGER_MAX_TOTAL_CONN = "conn_mgr.pooling.max_conn_total";
    public static final String POOLING_CONN_MANAGER_MAX_PER_CONN = "conn_mgr.pooling.max_per_conn";
    public static final String REQUEST_TIME_OUT_MS_KEY = "req_time_out";
    public static final String CONNECTION_TIME_OUT_MS_KEY = "conn_time_out";
    public static final String STATIC_SVC_ENDPOINT = "static_svc_endpoint";
    private static final Config FALLBACK = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"req_time_out", (Object)TimeUnit.SECONDS.toMillis(5L)).put((Object)"conn_time_out", (Object)TimeUnit.SECONDS.toMillis(5L)).put((Object)"conn_mgr_type", (Object)ConnManager.BASIC.name()).put((Object)"conn_mgr.pooling.max_conn_total", (Object)20).put((Object)"conn_mgr.pooling.max_per_conn", (Object)2).build());
    private State state = new State();
    private Optional<HttpClientBuilder> httpClientBuilder = Optional.absent();
    private HttpClientConnectionManager httpConnManager;
    private long reqTimeOut;
    private Optional<Logger> logger = Optional.absent();
    private Optional<URI> svcEndpoint = Optional.absent();

    public B writeTo(Destination destination) {
        super.writeTo(destination);
        this.fromState(destination.getProperties());
        return (B)((Object)((AbstractHttpWriterBuilder)this.typedSelf()));
    }

    public B fromState(State state) {
        this.state = state;
        Config config = ConfigBuilder.create().loadProps(state.getProperties(), CONF_PREFIX).build();
        this.fromConfig(config);
        return (B)((Object)((AbstractHttpWriterBuilder)this.typedSelf()));
    }

    public B fromConfig(Config config) {
        config = config.withFallback((ConfigMergeable)FALLBACK);
        RequestConfig requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(config.getInt(REQUEST_TIME_OUT_MS_KEY)).setConnectTimeout(config.getInt(CONNECTION_TIME_OUT_MS_KEY)).setConnectionRequestTimeout(config.getInt(CONNECTION_TIME_OUT_MS_KEY)).build();
        this.getHttpClientBuilder().setDefaultRequestConfig(requestConfig);
        if (config.hasPath(STATIC_SVC_ENDPOINT)) {
            try {
                this.svcEndpoint = Optional.of((Object)new URI(config.getString(STATIC_SVC_ENDPOINT)));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        String connMgrStr = config.getString(HTTP_CONN_MANAGER);
        switch (ConnManager.valueOf(connMgrStr.toUpperCase())) {
            case BASIC: {
                this.httpConnManager = new BasicHttpClientConnectionManager();
                break;
            }
            case POOLING: {
                PoolingHttpClientConnectionManager poolingConnMgr = new PoolingHttpClientConnectionManager();
                poolingConnMgr.setMaxTotal(config.getInt(POOLING_CONN_MANAGER_MAX_TOTAL_CONN));
                poolingConnMgr.setDefaultMaxPerRoute(config.getInt(POOLING_CONN_MANAGER_MAX_PER_CONN));
                this.httpConnManager = poolingConnMgr;
                break;
            }
            default: {
                throw new IllegalArgumentException(connMgrStr + " is not supported");
            }
        }
        LOG.info("Using " + this.httpConnManager.getClass().getSimpleName());
        return (B)((Object)((AbstractHttpWriterBuilder)this.typedSelf()));
    }

    public HttpClientBuilder getDefaultHttpClientBuilder() {
        HttpClientConfiguratorLoader clientConfiguratorLoader = new HttpClientConfiguratorLoader(this.getState());
        clientConfiguratorLoader.getConfigurator().setStatePropertiesPrefix(CONF_PREFIX);
        return clientConfiguratorLoader.getConfigurator().configure(this.getState()).getBuilder().disableCookieManagement().useSystemProperties();
    }

    public HttpClientBuilder getHttpClientBuilder() {
        if (!this.httpClientBuilder.isPresent()) {
            this.httpClientBuilder = Optional.of((Object)this.getDefaultHttpClientBuilder());
        }
        return (HttpClientBuilder)this.httpClientBuilder.get();
    }

    public B withHttpClientBuilder(HttpClientBuilder builder) {
        this.httpClientBuilder = Optional.of((Object)builder);
        return (B)((Object)((AbstractHttpWriterBuilder)this.typedSelf()));
    }

    public B withHttpClientConnectionManager(HttpClientConnectionManager connManager) {
        this.httpConnManager = connManager;
        return (B)((Object)((AbstractHttpWriterBuilder)this.typedSelf()));
    }

    public B withLogger(Logger logger) {
        this.logger = Optional.fromNullable((Object)logger);
        return (B)((Object)((AbstractHttpWriterBuilder)this.typedSelf()));
    }

    void validate() {
        Preconditions.checkNotNull((Object)this.getState(), (Object)("State is required for " + ((Object)((Object)this)).getClass().getSimpleName()));
        Preconditions.checkNotNull((Object)this.getHttpClientBuilder(), (Object)("HttpClientBuilder is required for " + ((Object)((Object)this)).getClass().getSimpleName()));
        Preconditions.checkNotNull((Object)this.getHttpConnManager(), (Object)("HttpConnManager is required for " + ((Object)((Object)this)).getClass().getSimpleName()));
    }

    public State getState() {
        return this.state;
    }

    public HttpClientConnectionManager getHttpConnManager() {
        return this.httpConnManager;
    }

    public long getReqTimeOut() {
        return this.reqTimeOut;
    }

    public Optional<Logger> getLogger() {
        return this.logger;
    }

    public Optional<URI> getSvcEndpoint() {
        return this.svcEndpoint;
    }

    public static enum ConnManager {
        POOLING,
        BASIC;

    }
}

