/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.http;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.gobblin.instrumented.writer.InstrumentedDataWriter;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.writer.http.AbstractHttpWriterBuilder;
import org.apache.gobblin.writer.http.DelegatingHttpClientConnectionManager;
import org.apache.gobblin.writer.http.HttpWriterDecoration;
import org.apache.gobblin.writer.http.UnexpectedResponseException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpWriter<D>
extends InstrumentedDataWriter<D>
implements HttpWriterDecoration<D> {
    protected final Logger log;
    protected final boolean debugLogEnabled;
    protected final CloseableHttpClient client;
    private final ListeningExecutorService singleThreadPool;
    private URI curHttpHost = null;
    private long numRecordsWritten = 0L;
    private long numBytesWritten = 0L;
    Optional<HttpUriRequest> curRequest = Optional.absent();

    public AbstractHttpWriter(AbstractHttpWriterBuilder builder) {
        super(builder.getState());
        this.log = builder.getLogger().isPresent() ? (Logger)builder.getLogger() : LoggerFactory.getLogger(this.getClass());
        this.debugLogEnabled = this.log.isDebugEnabled();
        HttpClientBuilder httpClientBuilder = builder.getHttpClientBuilder();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new HttpClientConnectionManagerWithConnTracking(builder.getHttpConnManager()));
        this.client = httpClientBuilder.build();
        this.singleThreadPool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
        if (builder.getSvcEndpoint().isPresent()) {
            this.setCurServerHost((URI)builder.getSvcEndpoint().get());
        }
    }

    public void cleanup() throws IOException {
        this.client.close();
        ExecutorsUtils.shutdownExecutorService((ExecutorService)this.singleThreadPool, (Optional)Optional.of((Object)this.log));
    }

    public void close() throws IOException {
        this.cleanup();
        super.close();
    }

    public long recordsWritten() {
        return this.numRecordsWritten;
    }

    public long bytesWritten() throws IOException {
        return this.numBytesWritten;
    }

    public void writeImpl(D record) throws IOException {
        if (!this.isRetry()) {
            this.curRequest = this.onNewRecord(record);
        }
        if (this.curRequest.isPresent()) {
            ListenableFuture<CloseableHttpResponse> responseFuture = this.sendRequest((HttpUriRequest)this.curRequest.get());
            try (CloseableHttpResponse response = this.waitForResponse(responseFuture);){
                this.processResponse(response);
            }
            this.curRequest = Optional.absent();
        }
        ++this.numRecordsWritten;
    }

    public void commit() throws IOException {
        this.flush();
        super.commit();
    }

    public void flush() {
    }

    @Override
    public ListenableFuture<CloseableHttpResponse> sendRequest(final HttpUriRequest request) throws IOException {
        return this.singleThreadPool.submit((Callable)new Callable<CloseableHttpResponse>(){

            @Override
            public CloseableHttpResponse call() throws Exception {
                return AbstractHttpWriter.this.client.execute(request);
            }
        });
    }

    public boolean isRetry() {
        return this.curRequest.isPresent();
    }

    @Override
    public CloseableHttpResponse waitForResponse(ListenableFuture<CloseableHttpResponse> responseFuture) {
        try {
            return (CloseableHttpResponse)responseFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void processResponse(CloseableHttpResponse response) throws IOException, UnexpectedResponseException {
        if (response.getStatusLine().getStatusCode() >= 400) {
            if (response.getEntity() != null) {
                throw new RuntimeException("Failed. " + EntityUtils.toString((HttpEntity)response.getEntity()) + " , response: " + ToStringBuilder.reflectionToString((Object)response, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
            }
            throw new RuntimeException("Failed. Response: " + ToStringBuilder.reflectionToString((Object)response, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public URI getCurServerHost() {
        if (null == this.curHttpHost) {
            this.setCurServerHost(this.chooseServerHost());
        }
        if (null == this.curHttpHost) {
            throw new RuntimeException("No server host selected!");
        }
        return this.curHttpHost;
    }

    void clearCurServerHost() {
        this.curHttpHost = null;
    }

    void setCurServerHost(URI curHttpHost) {
        this.log.info("Setting current HTTP server host to: " + curHttpHost);
        this.curHttpHost = curHttpHost;
    }

    class HttpClientConnectionManagerWithConnTracking
    extends DelegatingHttpClientConnectionManager {
        public HttpClientConnectionManagerWithConnTracking(HttpClientConnectionManager fallback) {
            super(fallback);
        }

        @Override
        public ConnectionRequest requestConnection(HttpRoute route, Object state) {
            try {
                AbstractHttpWriter.this.onConnect(new URI(route.getTargetHost().toURI()));
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException("onConnect() callback failure: " + e, e);
            }
            return super.requestConnection(route, state);
        }
    }
}

