/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.util.Collections;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.codec.StreamCodec;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.AvroUtils;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.util.WriterUtils;
import org.apache.gobblin.writer.PartitionAwareDataWriterBuilder;
import org.apache.gobblin.writer.WriterOutputFormat;
import org.apache.hadoop.fs.Path;

public abstract class FsDataWriterBuilder<S, D>
extends PartitionAwareDataWriterBuilder<S, D> {
    public static final String WRITER_INCLUDE_PARTITION_IN_FILE_NAMES = "writer.include.partition.in.file.names";
    public static final String WRITER_REPLACE_PATH_SEPARATORS_IN_PARTITIONS = "writer.replace.path.separators.in.partitions";
    private List<StreamCodec> encoders;

    public String getFileName(State properties) {
        List<StreamCodec> encoders;
        String extension = this.format.equals((Object)WriterOutputFormat.OTHER) ? FsDataWriterBuilder.getExtension(properties) : this.format.getExtension();
        String fileName = WriterUtils.getWriterFileName((State)properties, (int)this.branches, (int)this.branch, (String)this.writerId, (String)extension);
        if (this.partition.isPresent()) {
            fileName = this.getPartitionedFileName(properties, fileName);
        }
        if (!(encoders = this.getEncoders()).isEmpty()) {
            StringBuilder filenameBuilder = new StringBuilder(fileName);
            for (StreamCodec codec : encoders) {
                filenameBuilder.append('.');
                filenameBuilder.append(codec.getTag());
            }
            fileName = filenameBuilder.toString();
        }
        return fileName;
    }

    private static String getExtension(State properties) {
        return properties.getProp("writer.output.format", "");
    }

    protected String getPartitionPath(State properties) {
        if (this.partition.isPresent()) {
            boolean includePartitionerFieldNames = properties.getPropAsBoolean(ForkOperatorUtils.getPropertyNameForBranch((String)WRITER_INCLUDE_PARTITION_IN_FILE_NAMES, (int)this.branches, (int)this.branch), false);
            boolean removePathSeparators = properties.getPropAsBoolean(ForkOperatorUtils.getPropertyNameForBranch((String)WRITER_REPLACE_PATH_SEPARATORS_IN_PARTITIONS, (int)this.branches, (int)this.branch), false);
            return AvroUtils.serializeAsPath((GenericRecord)((GenericRecord)this.partition.get()), (boolean)includePartitionerFieldNames, (boolean)removePathSeparators).toString();
        }
        return null;
    }

    protected String getPartitionedFileName(State properties, String originalFileName) {
        return new Path(this.getPartitionPath(properties), originalFileName).toString();
    }

    public boolean validatePartitionSchema(Schema partitionSchema) {
        return true;
    }

    public synchronized List<StreamCodec> getEncoders() {
        if (this.encoders == null) {
            this.encoders = this.buildEncoders();
        }
        return this.encoders;
    }

    protected List<StreamCodec> buildEncoders() {
        return Collections.emptyList();
    }
}

