/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.utils;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.source.extractor.watermark.WatermarkType;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static final Gson GSON = new Gson();
    private static final String CURRENT_DAY = "CURRENTDAY";
    private static final String CURRENT_HOUR = "CURRENTHOUR";
    private static final String CURRENT_DATE_FORMAT = "yyyyMMddHHmmss";

    public static String getCoalesceColumnNames(String columnOrColumnList) {
        if (Strings.isNullOrEmpty((String)columnOrColumnList)) {
            return null;
        }
        if (columnOrColumnList.contains(",")) {
            return "COALESCE(" + columnOrColumnList + ")";
        }
        return columnOrColumnList;
    }

    public static JsonArray removeElementFromJsonArray(JsonArray inputJsonArray, String key) {
        JsonArray outputJsonArray = new JsonArray();
        for (int i = 0; i < inputJsonArray.size(); ++i) {
            JsonObject jsonObject = inputJsonArray.get(i).getAsJsonObject();
            outputJsonArray.add((JsonElement)Utils.removeElementFromJsonObject(jsonObject, key));
        }
        return outputJsonArray;
    }

    public static JsonObject removeElementFromJsonObject(JsonObject jsonObject, String key) {
        if (jsonObject != null) {
            jsonObject.remove(key);
            return jsonObject;
        }
        return null;
    }

    public static String toDateTimeFormat(String input, String inputfmt, String outputfmt) {
        Date date = null;
        SimpleDateFormat infmt = new SimpleDateFormat(inputfmt);
        try {
            date = infmt.parse(input);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SimpleDateFormat outFormat = new SimpleDateFormat(outputfmt);
        return outFormat.format(date);
    }

    public static Date toDate(String input, String inputfmt, String outputfmt) {
        SimpleDateFormat inputFormat = new SimpleDateFormat(inputfmt);
        SimpleDateFormat outputFormat = new SimpleDateFormat(outputfmt);
        Date outDate = null;
        try {
            Date date = inputFormat.parse(input);
            String dateStr = outputFormat.format(date);
            outDate = outputFormat.parse(dateStr);
        }
        catch (ParseException e) {
            LOG.error("Parse to date failed", (Throwable)e);
        }
        return outDate;
    }

    public static Date toDate(String input, String inputfmt) {
        SimpleDateFormat inputFormat = new SimpleDateFormat(inputfmt);
        Date outDate = null;
        try {
            outDate = inputFormat.parse(input);
        }
        catch (ParseException e) {
            LOG.error("Parse to date failed", (Throwable)e);
        }
        return outDate;
    }

    public static String epochToDate(long epoch, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = new Date(epoch);
        return sdf.format(date);
    }

    public static long getAsLong(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return 0L;
        }
        return Long.parseLong(value);
    }

    public static int getAsInt(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public static Date toDate(long value, String format) {
        SimpleDateFormat fmt = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = fmt.parse(Long.toString(value));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date toDate(Date date, String format) {
        SimpleDateFormat fmt = new SimpleDateFormat(format);
        String dateStr = fmt.format(date);
        Date outDate = null;
        try {
            outDate = fmt.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return outDate;
    }

    public static String dateToString(Date datetime, String format) {
        SimpleDateFormat fmt = new SimpleDateFormat(format);
        return fmt.format(datetime);
    }

    public static Date addDaysToDate(Date datetime, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(datetime);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date addHoursToDate(Date datetime, int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(datetime);
        calendar.add(10, hours);
        return calendar.getTime();
    }

    public static Date addSecondsToDate(Date datetime, int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(datetime);
        calendar.add(13, seconds);
        return calendar.getTime();
    }

    public static boolean isSimpleWatermark(WatermarkType watermarkType) {
        return watermarkType == WatermarkType.SIMPLE;
    }

    public static String printTiming(long start, long end) {
        long totalMillis = end - start;
        long mins = TimeUnit.MILLISECONDS.toMinutes(totalMillis);
        long secs = TimeUnit.MILLISECONDS.toSeconds(totalMillis) - TimeUnit.MINUTES.toSeconds(mins);
        long millis = TimeUnit.MILLISECONDS.toMillis(totalMillis) - TimeUnit.MINUTES.toMillis(mins) - TimeUnit.SECONDS.toMillis(secs);
        return String.format("%d min, %d sec, %d millis", mins, secs, millis);
    }

    public static List<String> getColumnListFromQuery(String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return null;
        }
        String queryLowerCase = query.toLowerCase();
        int startIndex = queryLowerCase.indexOf("select ") + 7;
        int endIndex = queryLowerCase.indexOf(" from ");
        if (startIndex < 0 || endIndex < 0) {
            return null;
        }
        String[] inputQueryColumns = query.substring(startIndex, endIndex).toLowerCase().replaceAll(" ", "").split(",");
        return Arrays.asList(inputQueryColumns);
    }

    public static JsonObject csvToJsonObject(List<String> bulkRecordHeader, List<String> record, int columnCount) {
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> resultInfo = new HashMap<String, String>();
        for (int i = 0; i < columnCount; ++i) {
            resultInfo.put(bulkRecordHeader.get(i), record.get(i));
        }
        JsonNode json = mapper.valueToTree(resultInfo);
        JsonElement element = (JsonElement)GSON.fromJson(json.toString(), JsonObject.class);
        return element.getAsJsonObject();
    }

    public static int getAsInt(String value, int defaultValue) {
        return Strings.isNullOrEmpty((String)value) ? defaultValue : Integer.parseInt(value);
    }

    public static boolean getPropAsBoolean(Properties properties, String key, String defaultValue) {
        return Boolean.valueOf(properties.getProperty(key, defaultValue));
    }

    public static String escapeSpecialCharacters(String columnName, String escapeChars, String character) {
        if (Strings.isNullOrEmpty((String)columnName)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)escapeChars)) {
            return columnName;
        }
        List<String> specialChars = Arrays.asList(escapeChars.split(","));
        for (String specialChar : specialChars) {
            columnName = columnName.replace(specialChar, character);
        }
        return columnName;
    }

    public static long getLongWithCurrentDate(String value, String timezone) {
        if (Strings.isNullOrEmpty((String)value)) {
            return 0L;
        }
        DateTime time = Utils.getCurrentTime(timezone);
        DateTimeFormatter dtFormatter = DateTimeFormat.forPattern((String)CURRENT_DATE_FORMAT).withZone(time.getZone());
        if (value.toUpperCase().startsWith(CURRENT_DAY)) {
            return Long.parseLong(dtFormatter.print((ReadableInstant)time.minusDays(Integer.parseInt(value.substring(CURRENT_DAY.length() + 1)))));
        }
        if (value.toUpperCase().startsWith(CURRENT_HOUR)) {
            return Long.parseLong(dtFormatter.print((ReadableInstant)time.minusHours(Integer.parseInt(value.substring(CURRENT_HOUR.length() + 1)))));
        }
        return Long.parseLong(value);
    }

    public static String dateTimeToString(DateTime input, String format, String timezone) {
        String tz = StringUtils.defaultString((String)timezone, (String)"America/Los_Angeles");
        DateTimeZone dateTimeZone = Utils.getTimeZone(tz);
        DateTimeFormatter outputDtFormat = DateTimeFormat.forPattern((String)format).withZone(dateTimeZone);
        return outputDtFormat.print((ReadableInstant)input);
    }

    public static DateTime getCurrentTime(String timezone) {
        String tz = StringUtils.defaultString((String)timezone, (String)"America/Los_Angeles");
        DateTimeZone dateTimeZone = Utils.getTimeZone(tz);
        DateTime currentTime = new DateTime(dateTimeZone);
        return currentTime;
    }

    public static DateTime toDateTime(String input, String format, String timezone) {
        String tz = StringUtils.defaultString((String)timezone, (String)"America/Los_Angeles");
        DateTimeZone dateTimeZone = Utils.getTimeZone(tz);
        DateTimeFormatter inputDtFormat = DateTimeFormat.forPattern((String)format).withZone(dateTimeZone);
        DateTime outputDateTime = inputDtFormat.parseDateTime(input).withZone(dateTimeZone);
        return outputDateTime;
    }

    public static DateTime toDateTime(long input, String format, String timezone) {
        return Utils.toDateTime(Long.toString(input), format, timezone);
    }

    private static DateTimeZone getTimeZone(String id) {
        DateTimeZone zone;
        try {
            zone = DateTimeZone.forID((String)id);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("TimeZone " + id + " not recognized");
        }
        return zone;
    }
}

