/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.utils;

import java.io.Closeable;
import java.io.IOException;
import org.apache.avro.file.SeekableInput;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ProxyFsInput
implements Closeable,
SeekableInput {
    private final FSDataInputStream stream;
    private final long len;

    public ProxyFsInput(Path path, FileSystem fs) throws IOException {
        this.len = fs.getFileStatus(path).getLen();
        this.stream = fs.open(path);
    }

    public long length() {
        return this.len;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    public void seek(long p) throws IOException {
        this.stream.seek(p);
    }

    public long tell() throws IOException {
        return this.stream.getPos();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

