/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.partition;

import org.apache.gobblin.source.extractor.Watermark;
import org.apache.gobblin.source.extractor.WatermarkInterval;
import org.apache.gobblin.source.extractor.extract.LongWatermark;
import org.apache.gobblin.source.workunit.WorkUnit;

public class Partition {
    public static final String IS_LAST_PARTIITON = "partition.isLastPartition";
    public static final String HAS_USER_SPECIFIED_HIGH_WATERMARK = "partition.hasUserSpecifiedHighWatermark";
    private final long lowWatermark;
    private final boolean isLowWatermarkInclusive;
    private final long highWatermark;
    private final boolean isHighWatermarkInclusive;
    private final boolean isLastPartition;
    private final boolean hasUserSpecifiedHighWatermark;

    public Partition(long lowWatermark, long highWatermark, boolean isLastPartition, boolean hasUserSpecifiedHighWatermark) {
        this.lowWatermark = lowWatermark;
        this.highWatermark = highWatermark;
        this.isLowWatermarkInclusive = true;
        this.isHighWatermarkInclusive = isLastPartition;
        this.isLastPartition = isLastPartition;
        this.hasUserSpecifiedHighWatermark = hasUserSpecifiedHighWatermark;
    }

    public Partition(long lowWatermark, long highWatermark, boolean hasUserSpecifiedHighWatermark) {
        this(lowWatermark, highWatermark, false, hasUserSpecifiedHighWatermark);
    }

    public Partition(long lowWatermark, long highWatermark) {
        this(lowWatermark, highWatermark, false);
    }

    public boolean getHasUserSpecifiedHighWatermark() {
        return this.hasUserSpecifiedHighWatermark;
    }

    public void serialize(WorkUnit workUnit) {
        workUnit.setWatermarkInterval(new WatermarkInterval((Watermark)new LongWatermark(this.lowWatermark), (Watermark)new LongWatermark(this.highWatermark)));
        if (this.hasUserSpecifiedHighWatermark) {
            workUnit.setProp(HAS_USER_SPECIFIED_HIGH_WATERMARK, (Object)true);
        }
        if (this.isLastPartition) {
            workUnit.setProp(IS_LAST_PARTIITON, (Object)true);
        }
    }

    public static Partition deserialize(WorkUnit workUnit) {
        long lowWatermark = -1L;
        long highWatermark = -1L;
        if (workUnit.getProp("watermark.interval.value") != null) {
            lowWatermark = ((LongWatermark)workUnit.getLowWatermark(LongWatermark.class)).getValue();
            highWatermark = ((LongWatermark)workUnit.getExpectedHighWatermark(LongWatermark.class)).getValue();
        }
        return new Partition(lowWatermark, highWatermark, workUnit.getPropAsBoolean(IS_LAST_PARTIITON), workUnit.getPropAsBoolean(HAS_USER_SPECIFIED_HIGH_WATERMARK));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Partition)) {
            return false;
        }
        Partition other = (Partition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLowWatermark() != other.getLowWatermark()) {
            return false;
        }
        if (this.isLowWatermarkInclusive() != other.isLowWatermarkInclusive()) {
            return false;
        }
        if (this.getHighWatermark() != other.getHighWatermark()) {
            return false;
        }
        if (this.isHighWatermarkInclusive() != other.isHighWatermarkInclusive()) {
            return false;
        }
        if (this.isLastPartition() != other.isLastPartition()) {
            return false;
        }
        return this.getHasUserSpecifiedHighWatermark() == other.getHasUserSpecifiedHighWatermark();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Partition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lowWatermark = this.getLowWatermark();
        result = result * 59 + (int)($lowWatermark >>> 32 ^ $lowWatermark);
        result = result * 59 + (this.isLowWatermarkInclusive() ? 79 : 97);
        long $highWatermark = this.getHighWatermark();
        result = result * 59 + (int)($highWatermark >>> 32 ^ $highWatermark);
        result = result * 59 + (this.isHighWatermarkInclusive() ? 79 : 97);
        result = result * 59 + (this.isLastPartition() ? 79 : 97);
        result = result * 59 + (this.getHasUserSpecifiedHighWatermark() ? 79 : 97);
        return result;
    }

    public long getLowWatermark() {
        return this.lowWatermark;
    }

    public boolean isLowWatermarkInclusive() {
        return this.isLowWatermarkInclusive;
    }

    public long getHighWatermark() {
        return this.highWatermark;
    }

    public boolean isHighWatermarkInclusive() {
        return this.isHighWatermarkInclusive;
    }

    public boolean isLastPartition() {
        return this.isLastPartition;
    }
}

