/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.qualitychecker.task;

import java.util.List;
import org.apache.gobblin.qualitychecker.task.TaskLevelPolicy;
import org.apache.gobblin.qualitychecker.task.TaskLevelPolicyCheckResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskLevelPolicyChecker {
    private final List<TaskLevelPolicy> list;
    private static final Logger LOG = LoggerFactory.getLogger(TaskLevelPolicyChecker.class);

    public TaskLevelPolicyChecker(List<TaskLevelPolicy> list) {
        this.list = list;
    }

    public TaskLevelPolicyCheckResults executePolicies() {
        TaskLevelPolicyCheckResults results = new TaskLevelPolicyCheckResults();
        for (TaskLevelPolicy p : this.list) {
            TaskLevelPolicy.Result result = p.executePolicy();
            results.getPolicyResults().put(result, p.getType());
            LOG.info("TaskLevelPolicy " + p + " of type " + p.getType() + " executed with result " + result);
        }
        return results;
    }
}

