/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.publisher;

import java.util.Map;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.qualitychecker.task.TaskLevelPolicy;
import org.apache.gobblin.qualitychecker.task.TaskLevelPolicyCheckResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskPublisher {
    private final TaskLevelPolicyCheckResults results;
    private static final Logger LOG = LoggerFactory.getLogger(TaskPublisher.class);

    public TaskPublisher(WorkUnitState workUnitState, TaskLevelPolicyCheckResults results) throws Exception {
        this.results = results;
    }

    public PublisherState canPublish() throws Exception {
        if (this.allComponentsFinished()) {
            LOG.info("All components finished successfully, checking quality tests");
            if (this.passedAllTests()) {
                LOG.info("All required test passed for this task passed.");
                if (this.cleanup()) {
                    LOG.info("Cleanup for task publisher executed successfully.");
                    return PublisherState.SUCCESS;
                }
                return PublisherState.CLEANUP_FAIL;
            }
            return PublisherState.POLICY_TESTS_FAIL;
        }
        return PublisherState.COMPONENTS_NOT_FINISHED;
    }

    public boolean passedAllTests() {
        for (Map.Entry<TaskLevelPolicy.Result, TaskLevelPolicy.Type> entry : this.results.getPolicyResults().entrySet()) {
            if (!entry.getKey().equals((Object)TaskLevelPolicy.Result.FAILED) || !entry.getValue().equals((Object)TaskLevelPolicy.Type.FAIL)) continue;
            return false;
        }
        return true;
    }

    public boolean allComponentsFinished() {
        return true;
    }

    public boolean cleanup() throws Exception {
        return true;
    }

    public static enum PublisherState {
        SUCCESS,
        CLEANUP_FAIL,
        POLICY_TESTS_FAIL,
        COMPONENTS_NOT_FINISHED;

    }
}

