/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.policies.count;

import org.apache.gobblin.configuration.State;
import org.apache.gobblin.qualitychecker.task.TaskLevelPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowCountPolicy
extends TaskLevelPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(RowCountPolicy.class);
    private final long rowsRead;
    private final long rowsWritten;

    public RowCountPolicy(State state, TaskLevelPolicy.Type type) {
        super(state, type);
        this.rowsRead = state.getPropAsLong("qualitychecker.rows.expected");
        this.rowsWritten = state.getPropAsLong("qualitychecker.rows.written");
    }

    public TaskLevelPolicy.Result executePolicy() {
        if (this.rowsRead == this.rowsWritten) {
            return TaskLevelPolicy.Result.PASSED;
        }
        LOG.warn(((Object)((Object)this)).getClass().getSimpleName() + " fails as read count and write count mismatch: " + (Object)((Object)this));
        return TaskLevelPolicy.Result.FAILED;
    }

    public String toString() {
        return String.format("RowCountPolicy [rowsRead=%s, rowsWritten=%s]", this.rowsRead, this.rowsWritten);
    }
}

