/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.initializer;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.gobblin.initializer.Initializer;

public class MultiInitializer
implements Initializer {
    private final List<Initializer> initializers;
    private final Closer closer;

    public MultiInitializer(List<? extends Initializer> initializers) {
        this.initializers = ImmutableList.copyOf(initializers);
        this.closer = Closer.create();
        for (Initializer initializer : this.initializers) {
            this.closer.register((Closeable)initializer);
        }
    }

    public void initialize() {
        for (Initializer initializer : this.initializers) {
            initializer.initialize();
        }
    }

    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "MultiInitializer(initializers=" + this.initializers + ", closer=" + this.closer + ")";
    }
}

