/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.string;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.EmptyIterable;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.util.ForkOperatorUtils;

public class StringFilterConverter
extends Converter<Class<String>, Class<String>, String, String> {
    private Pattern pattern;
    private Optional<Matcher> matcher;

    public Converter<Class<String>, Class<String>, String, String> init(WorkUnitState workUnit) {
        this.pattern = Pattern.compile(Strings.nullToEmpty((String)workUnit.getProp(ForkOperatorUtils.getPropertyNameForBranch((WorkUnitState)workUnit, (String)"converter.string.filter.pattern"))));
        this.matcher = Optional.absent();
        return this;
    }

    public Class<String> convertSchema(Class<String> inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return inputSchema;
    }

    public Iterable<String> convertRecord(Class<String> outputSchema, String inputRecord, WorkUnitState workUnit) throws DataConversionException {
        if (!this.matcher.isPresent()) {
            this.matcher = Optional.of((Object)this.pattern.matcher(inputRecord));
        } else {
            ((Matcher)this.matcher.get()).reset(inputRecord);
        }
        return ((Matcher)this.matcher.get()).matches() ? new SingleRecordIterable((Object)inputRecord) : new EmptyIterable();
    }
}

