/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.serde;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.hive.HiveSerDeWrapper;
import org.apache.gobblin.instrumented.converter.InstrumentedConverter;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.avro.AvroObjectInspectorGenerator;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSerDeConverter
extends InstrumentedConverter<Object, Object, Writable, Writable> {
    private static final Logger log = LoggerFactory.getLogger(HiveSerDeConverter.class);
    private SerDe serializer;
    private SerDe deserializer;

    public HiveSerDeConverter init(WorkUnitState state) {
        super.init(state);
        Configuration conf = HadoopUtils.getConfFromState((State)state);
        try {
            this.serializer = HiveSerDeWrapper.getSerializer((State)state).getSerDe();
            this.deserializer = HiveSerDeWrapper.getDeserializer((State)state).getSerDe();
            this.deserializer.initialize(conf, state.getProperties());
            this.setColumnsIfPossible(state);
            this.serializer.initialize(conf, state.getProperties());
        }
        catch (IOException e) {
            log.error("Failed to instantiate serializer and deserializer", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        catch (SerDeException e) {
            log.error("Failed to initialize serializer and deserializer", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        return this;
    }

    private void setColumnsIfPossible(WorkUnitState state) throws SerDeException {
        AvroObjectInspectorGenerator aoig = new AvroObjectInspectorGenerator(AvroSerdeUtils.determineSchemaOrReturnErrorSchema((Properties)state.getProperties()));
        List columnNames = aoig.getColumnNames();
        List columnTypes = aoig.getColumnTypes();
        state.setProp("columns", (Object)StringUtils.join((Iterable)columnNames, (String)","));
        state.setProp("columns.types", (Object)StringUtils.join((Iterable)columnTypes, (String)","));
    }

    public Iterable<Writable> convertRecordImpl(Object outputSchema, Writable inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try {
            Object deserialized = this.deserializer.deserialize(inputRecord);
            Writable convertedRecord = this.serializer.serialize(deserialized, this.deserializer.getObjectInspector());
            return new SingleRecordIterable((Object)convertedRecord);
        }
        catch (SerDeException e) {
            throw new DataConversionException((Throwable)e);
        }
    }

    public Object convertSchema(Object inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return inputSchema;
    }
}

