/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.http;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigSyntax;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.converter.http.RestEntry;

public class AvroToRestJsonEntryConverter
extends Converter<Schema, Void, GenericRecord, RestEntry<JsonObject>> {
    static final String CONVERTER_AVRO_REST_ENTRY_RESOURCE_KEY = "converter.avro.rest.resource_key";
    static final String CONVERTER_AVRO_REST_JSON_ENTRY_TEMPLATE = "converter.avro.rest.json_hocon_template";
    private final JsonParser parser = new JsonParser();

    public Void convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return null;
    }

    public Iterable<RestEntry<JsonObject>> convertRecord(Void outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        String hoconInput;
        Config srcConfig = ConfigFactory.parseString((String)inputRecord.toString(), (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.JSON));
        String resourceKey = workUnit.getProp(CONVERTER_AVRO_REST_ENTRY_RESOURCE_KEY, "");
        if (!StringUtils.isEmpty((CharSequence)resourceKey)) {
            String dummyKey = "DUMMY";
            Config tmpConfig = ConfigFactory.parseString((String)("DUMMY=" + resourceKey)).resolveWith(srcConfig);
            resourceKey = tmpConfig.getString("DUMMY");
        }
        if (StringUtils.isEmpty((CharSequence)(hoconInput = workUnit.getProp(CONVERTER_AVRO_REST_JSON_ENTRY_TEMPLATE)))) {
            return new SingleRecordIterable(new RestEntry<JsonObject>(resourceKey, this.parser.parse(inputRecord.toString()).getAsJsonObject()));
        }
        Config destConfig = ConfigFactory.parseString((String)hoconInput).resolveWith(srcConfig);
        JsonObject json = this.parser.parse(destConfig.root().render(ConfigRenderOptions.concise())).getAsJsonObject();
        return new SingleRecordIterable(new RestEntry<JsonObject>(resourceKey, json));
    }
}

