/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConfigBuilder {
    private final Map<String, Object> primitiveProps = new HashMap<String, Object>();
    private final Optional<String> originDestription;
    private Config currentConfig;

    ConfigBuilder(Optional<String> originDescription) {
        this.originDestription = originDescription;
        this.currentConfig = originDescription.isPresent() ? ConfigFactory.empty((String)((String)this.originDestription.get())) : ConfigFactory.empty();
    }

    public ConfigBuilder loadProps(Properties props, String scopePrefix) {
        Preconditions.checkNotNull((Object)props);
        Preconditions.checkNotNull((Object)scopePrefix);
        int scopePrefixLen = scopePrefix.length();
        for (Map.Entry<Object, Object> propEntry : props.entrySet()) {
            String propName = propEntry.getKey().toString();
            if (!propName.startsWith(scopePrefix)) continue;
            String scopedName = propName.substring(scopePrefixLen);
            if (scopedName.isEmpty()) {
                throw new RuntimeException("Illegal scoped property:" + propName);
            }
            if (!Character.isAlphabetic(scopedName.charAt(0))) {
                throw new RuntimeException("Scoped name for property " + propName + " should start with a character: " + scopedName);
            }
            this.primitiveProps.put(scopedName, propEntry.getValue());
        }
        return this;
    }

    public ConfigBuilder addPrimitive(String name, Object value) {
        this.primitiveProps.put(name, value);
        return this;
    }

    public ConfigBuilder addList(String name, Iterable<? extends Object> values) {
        this.currentConfig = this.originDestription.isPresent() ? this.currentConfig.withValue(name, (ConfigValue)ConfigValueFactory.fromIterable(values, (String)((String)this.originDestription.get()))) : this.currentConfig.withValue(name, (ConfigValue)ConfigValueFactory.fromIterable(values));
        return this;
    }

    public static ConfigBuilder create() {
        return new ConfigBuilder((Optional<String>)Optional.absent());
    }

    public static ConfigBuilder create(String originDescription) {
        return new ConfigBuilder((Optional<String>)Optional.of((Object)originDescription));
    }

    public Config build() {
        return ConfigFactory.parseMap(this.primitiveProps).withFallback((ConfigMergeable)this.currentConfig);
    }
}

