/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.commit;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.commit.CommitSequence;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.commit.CommitStepBase;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class FsRenameCommitStep
extends CommitStepBase {
    private static final Logger log = LoggerFactory.getLogger(FsRenameCommitStep.class);
    private final Path srcPath;
    private final Path dstPath;
    private final String srcFsUri;
    private final String dstFsUri;
    private final boolean overwrite;
    private transient FileSystem srcFs;
    private transient FileSystem dstFs;

    private FsRenameCommitStep(Builder<? extends Builder<?>> builder) throws IOException {
        super(builder);
        this.srcPath = ((Builder)builder).srcPath;
        this.dstPath = ((Builder)builder).dstPath;
        this.srcFs = ((Builder)builder).srcFs != null ? ((Builder)builder).srcFs : this.getFileSystem(this.props.getProp("fs.uri", "file:///"));
        this.srcFsUri = this.srcFs.getUri().toString();
        this.dstFs = ((Builder)builder).dstFs != null ? ((Builder)builder).dstFs : this.getFileSystem(this.props.getProp("fs.uri", "file:///"));
        this.dstFsUri = this.dstFs.getUri().toString();
        this.overwrite = ((Builder)builder).overwrite;
    }

    private FileSystem getFileSystem(String fsUri) throws IOException {
        return FileSystem.get((URI)URI.create(fsUri), (Configuration)HadoopUtils.getConfFromState((State)this.props));
    }

    public boolean isCompleted() throws IOException {
        if (this.dstFs == null) {
            this.dstFs = this.getFileSystem(this.dstFsUri);
        }
        return this.dstFs.exists(this.dstPath);
    }

    public void execute() throws IOException {
        if (this.srcFs == null) {
            this.srcFs = this.getFileSystem(this.srcFsUri);
        }
        if (this.dstFs == null) {
            this.dstFs = this.getFileSystem(this.dstFsUri);
        }
        log.info(String.format("Moving %s to %s", this.srcPath, this.dstPath));
        HadoopUtils.movePath((FileSystem)this.srcFs, (Path)this.srcPath, (FileSystem)this.dstFs, (Path)this.dstPath, (boolean)this.overwrite, (Configuration)this.dstFs.getConf());
    }

    public static class Builder<T extends Builder<?>>
    extends CommitStepBase.Builder<T> {
        private Path srcPath;
        private Path dstPath;
        private FileSystem srcFs;
        private FileSystem dstFs;
        private boolean overwrite;

        public Builder() {
        }

        public Builder(CommitSequence.Builder commitSequenceBuilder) {
            super(commitSequenceBuilder);
        }

        public T withProps(State props) {
            return (T)((Object)((Builder)super.withProps(props)));
        }

        public T from(Path srcPath) {
            this.srcPath = srcPath;
            return (T)((Object)this);
        }

        public T to(Path dstPath) {
            this.dstPath = dstPath;
            return (T)((Object)this);
        }

        public T withSrcFs(FileSystem srcFs) {
            this.srcFs = srcFs;
            return (T)((Object)this);
        }

        public T withDstFs(FileSystem dstFs) {
            this.dstFs = dstFs;
            return (T)((Object)this);
        }

        public T overwrite() {
            this.overwrite = true;
            return (T)((Object)this);
        }

        public CommitStep build() throws IOException {
            Preconditions.checkNotNull((Object)this.srcPath);
            Preconditions.checkNotNull((Object)this.dstPath);
            return new FsRenameCommitStep(this);
        }
    }
}

