/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.validation;

import com.linkedin.data.schema.validation.ValidationResult;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.transform.filter.request.MaskTree;
import com.linkedin.restli.common.CreateIdEntityStatus;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.PatchRequest;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.common.validation.RestLiDataValidator;
import com.linkedin.restli.internal.server.response.BatchCreateResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchResponseEnvelope;
import com.linkedin.restli.server.RestLiRequestData;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.filter.Filter;
import com.linkedin.restli.server.filter.FilterRequestContext;
import com.linkedin.restli.server.filter.FilterResponseContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class RestLiValidationFilter
implements Filter {
    @Override
    public CompletableFuture<Void> onRequest(FilterRequestContext requestContext) {
        Class<?> resourceClass = requestContext.getFilterResourceModel().getResourceClass();
        ResourceMethod method = requestContext.getMethodType();
        RestLiDataValidator validator = new RestLiDataValidator(resourceClass.getAnnotations(), requestContext.getFilterResourceModel().getValueClass(), method);
        RestLiRequestData requestData = requestContext.getRequestData();
        if (method == ResourceMethod.CREATE || method == ResourceMethod.UPDATE) {
            ValidationResult result = validator.validateInput(requestData.getEntity());
            if (!result.isValid()) {
                throw new RestLiServiceException(HttpStatus.S_422_UNPROCESSABLE_ENTITY, result.getMessages().toString());
            }
        } else if (method == ResourceMethod.PARTIAL_UPDATE) {
            ValidationResult result = validator.validateInput((PatchRequest)requestData.getEntity());
            if (!result.isValid()) {
                throw new RestLiServiceException(HttpStatus.S_422_UNPROCESSABLE_ENTITY, result.getMessages().toString());
            }
        } else if (method == ResourceMethod.BATCH_CREATE) {
            StringBuilder sb = new StringBuilder();
            for (RecordTemplate recordTemplate : requestData.getBatchEntities()) {
                ValidationResult result = validator.validateInput(recordTemplate);
                if (result.isValid()) continue;
                sb.append(result.getMessages().toString());
            }
            if (sb.length() > 0) {
                throw new RestLiServiceException(HttpStatus.S_422_UNPROCESSABLE_ENTITY, sb.toString());
            }
        } else if (method == ResourceMethod.BATCH_UPDATE || method == ResourceMethod.BATCH_PARTIAL_UPDATE) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<?, RecordTemplate> entry : requestData.getBatchKeyEntityMap().entrySet()) {
                ValidationResult result = method == ResourceMethod.BATCH_UPDATE ? validator.validateInput(entry.getValue()) : validator.validateInput((PatchRequest)entry.getValue());
                if (result.isValid()) continue;
                sb.append("Key: ");
                sb.append(entry.getKey());
                sb.append(", ");
                sb.append(result.getMessages().toString());
            }
            if (sb.length() > 0) {
                throw new RestLiServiceException(HttpStatus.S_422_UNPROCESSABLE_ENTITY, sb.toString());
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onResponse(FilterRequestContext requestContext, FilterResponseContext responseContext) {
        Class<?> resourceClass = requestContext.getFilterResourceModel().getResourceClass();
        ResourceMethod method = requestContext.getMethodType();
        RestLiDataValidator validator = new RestLiDataValidator(resourceClass.getAnnotations(), requestContext.getFilterResourceModel().getValueClass(), method);
        RestLiResponseData responseData = responseContext.getResponseData();
        MaskTree projectionMask = requestContext.getProjectionMask();
        if (responseData.isErrorResponse()) {
            return CompletableFuture.completedFuture(null);
        }
        switch (method) {
            case GET: {
                this.validateSingleResponse(validator, responseData.getRecordResponseEnvelope().getRecord(), projectionMask);
                break;
            }
            case CREATE: {
                if (!requestContext.getCustomAnnotations().containsKey((Object)"returnEntity")) break;
                this.validateSingleResponse(validator, responseData.getRecordResponseEnvelope().getRecord(), projectionMask);
                break;
            }
            case GET_ALL: 
            case FINDER: {
                this.validateCollectionResponse(validator, responseData.getCollectionResponseEnvelope().getCollectionResponse(), projectionMask);
                break;
            }
            case BATCH_GET: {
                this.validateBatchResponse(validator, responseData.getBatchResponseEnvelope().getBatchResponseMap(), projectionMask);
                break;
            }
            case BATCH_CREATE: {
                if (!requestContext.getCustomAnnotations().containsKey((Object)"returnEntity")) break;
                this.validateCreateCollectionResponse(validator, responseData.getBatchCreateResponseEnvelope().getCreateResponses(), projectionMask);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    private void validateSingleResponse(RestLiDataValidator validator, RecordTemplate entity, MaskTree projectionMask) {
        ValidationResult result = validator.validateOutput(entity, projectionMask);
        if (!result.isValid()) {
            throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, result.getMessages().toString());
        }
    }

    private void validateCollectionResponse(RestLiDataValidator validator, List<? extends RecordTemplate> entities, MaskTree projectionMask) {
        StringBuilder sb = new StringBuilder();
        for (RecordTemplate recordTemplate : entities) {
            ValidationResult result = validator.validateOutput(recordTemplate, projectionMask);
            if (result.isValid()) continue;
            sb.append(result.getMessages().toString());
        }
        if (sb.length() > 0) {
            throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, sb.toString());
        }
    }

    private void validateBatchResponse(RestLiDataValidator validator, Map<?, BatchResponseEnvelope.BatchResponseEntry> batchResponseMap, MaskTree projectionMask) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, BatchResponseEnvelope.BatchResponseEntry> entry : batchResponseMap.entrySet()) {
            ValidationResult result;
            if (entry.getValue().hasException() || (result = validator.validateOutput(entry.getValue().getRecord(), projectionMask)).isValid()) continue;
            sb.append("Key: ");
            sb.append(entry.getKey());
            sb.append(", ");
            sb.append(result.getMessages().toString());
        }
        if (sb.length() > 0) {
            throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, sb.toString());
        }
    }

    private void validateCreateCollectionResponse(RestLiDataValidator validator, List<BatchCreateResponseEnvelope.CollectionCreateResponseItem> responses, MaskTree projectionMask) {
        StringBuilder sb = new StringBuilder();
        for (BatchCreateResponseEnvelope.CollectionCreateResponseItem item : responses) {
            ValidationResult result;
            if (item.isErrorResponse() || (result = validator.validateOutput(((CreateIdEntityStatus)item.getRecord()).getEntity(), projectionMask)).isValid()) continue;
            sb.append(result.getMessages().toString());
        }
        if (sb.length() > 0) {
            throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, sb.toString());
        }
    }

    @Override
    public CompletableFuture<Void> onError(Throwable t, FilterRequestContext requestContext, FilterResponseContext responseContext) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.completeExceptionally(t);
        return future;
    }
}

