/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.util;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.transform.DataComplexProcessor;
import com.linkedin.data.transform.Interpreter;
import com.linkedin.data.transform.filter.Filter;
import com.linkedin.data.transform.filter.request.MaskTree;
import com.linkedin.restli.common.PatchRequest;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class PatchHelper {
    private static final DataMap EMPTY_DATAMAP = new DataMap();

    public static <T extends RecordTemplate> PatchRequest<T> applyProjection(PatchRequest<T> patch, MaskTree projection) {
        try {
            DataMap forProjecting = patch.getPatchDocument().copy();
            PatchHelper.expose(forProjecting);
            DataMap projected = PatchHelper.project(forProjecting, projection);
            DataMap forTrimming = patch.getPatchDocument().copy();
            PatchHelper.trim(forTrimming, projected);
            return PatchRequest.createFromPatchDocument((DataMap)forTrimming);
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Patch must be cloneable in order to apply projection to it", e);
        }
    }

    private static void trim(DataMap doc, DataMap projected) {
        DataMap toAddDoc = new DataMap();
        Set fields = doc.keySet();
        ArrayList<String> toRemoveDoc = new ArrayList<String>(fields.size());
        for (String f : fields) {
            Object v = doc.get((Object)f);
            if (f.equals("$delete")) {
                DataList deletedFields = (DataList)v;
                DataList filteredDeleteFields = new DataList();
                for (Object patchDeleteField : deletedFields) {
                    if (!projected.containsKey(patchDeleteField)) continue;
                    filteredDeleteFields.add(patchDeleteField);
                }
                toRemoveDoc.add(f);
                if (filteredDeleteFields.isEmpty()) continue;
                toAddDoc.put((Object)"$delete", (Object)filteredDeleteFields);
                continue;
            }
            if (f.equals("$set")) {
                DataMap setFields = (DataMap)v;
                Set setFieldNames = setFields.keySet();
                LinkedList<String> toRemove = new LinkedList<String>();
                DataMap filteredSetFields = new DataMap();
                for (String setFieldName : setFieldNames) {
                    if (projected.containsKey((Object)setFieldName)) {
                        filteredSetFields.put((Object)setFieldName, projected.get((Object)setFieldName));
                    }
                    toRemove.add(setFieldName);
                }
                for (String fieldToRemove : toRemove) {
                    setFields.remove((Object)fieldToRemove);
                    if (!filteredSetFields.containsKey((Object)fieldToRemove)) continue;
                    setFields.put((Object)fieldToRemove, filteredSetFields.get((Object)fieldToRemove));
                }
                if (!setFields.isEmpty()) continue;
                toRemoveDoc.add(f);
                continue;
            }
            if (!(v instanceof DataMap)) continue;
            if (projected.containsKey((Object)f)) {
                PatchHelper.trim((DataMap)v, (DataMap)projected.get((Object)f));
                continue;
            }
            toRemoveDoc.add(f);
        }
        for (String f : toRemoveDoc) {
            doc.remove((Object)f);
        }
        for (String f : toAddDoc.keySet()) {
            doc.put((Object)f, toAddDoc.get((Object)f));
        }
    }

    private static DataMap project(DataMap forProjection, MaskTree projection) {
        if (projection == null) {
            return forProjection;
        }
        if (projection.getDataMap().isEmpty()) {
            return EMPTY_DATAMAP;
        }
        try {
            new DataComplexProcessor((Interpreter)new Filter(), projection.getDataMap(), (DataComplex)forProjection).run(false);
            return forProjection;
        }
        catch (Exception e) {
            throw new RuntimeException("Error projecting fields", e);
        }
    }

    private static void expose(DataMap doc) {
        Set fields = doc.keySet();
        DataMap toAdd = new DataMap();
        for (String f : fields) {
            Object v = doc.get((Object)f);
            if (f.equals("$delete")) {
                for (Object removedFields : (DataList)v) {
                    toAdd.put((Object)((String)removedFields), (Object)true);
                }
                continue;
            }
            if (f.equals("$set")) {
                toAdd.putAll((Map)((DataMap)v));
                continue;
            }
            if (!(v instanceof DataMap)) continue;
            PatchHelper.expose((DataMap)v);
        }
        doc.putAll((Map)toAdd);
    }

    static {
        EMPTY_DATAMAP.makeReadOnly();
    }
}

