/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.multiplexer;

import com.linkedin.data.ByteString;
import com.linkedin.data.template.StringMap;
import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.restli.common.multiplexer.IndividualBody;
import com.linkedin.restli.common.multiplexer.IndividualResponse;
import com.linkedin.restli.internal.common.DataMapConverter;
import com.linkedin.restli.server.multiplexer.IndividualResponseException;
import com.linkedin.restli.server.multiplexer.IndividualResponseWithCookies;
import java.io.IOException;
import java.util.Map;
import javax.activation.MimeTypeParseException;

final class IndividualResponseConversionTask
extends BaseTask<IndividualResponseWithCookies> {
    private final BaseTask<RestResponse> _restResponse;
    private final String _restResponseId;

    IndividualResponseConversionTask(String restResponseId, BaseTask<RestResponse> restResponse) {
        this._restResponse = restResponse;
        this._restResponseId = restResponseId;
    }

    protected Promise<? extends IndividualResponseWithCookies> run(Context context) throws Throwable {
        if (this._restResponse.isFailed()) {
            return Promises.value((Object)IndividualResponseConversionTask.toErrorIndividualResponse(this._restResponse.getError()));
        }
        try {
            RestResponse restResponse = (RestResponse)this._restResponse.get();
            IndividualResponse response = IndividualResponseConversionTask.toIndividualResponse(this._restResponseId, restResponse);
            return Promises.value((Object)new IndividualResponseWithCookies(response, restResponse.getCookies()));
        }
        catch (MimeTypeParseException e) {
            return Promises.value((Object)IndividualResponseConversionTask.createInternalServerErrorResponse("Invalid content type for individual response: " + this._restResponseId));
        }
        catch (IOException e) {
            return Promises.value((Object)IndividualResponseConversionTask.createInternalServerErrorResponse("Unable to set body for individual response: " + this._restResponseId));
        }
        catch (Exception e) {
            return Promises.value((Object)IndividualResponseConversionTask.toErrorIndividualResponse(e));
        }
    }

    private static IndividualResponse toIndividualResponse(String id, RestResponse restResponse) throws MimeTypeParseException, IOException {
        IndividualResponse individualResponse = new IndividualResponse();
        individualResponse.setStatus(restResponse.getStatus());
        individualResponse.setHeaders(new StringMap(restResponse.getHeaders()));
        ByteString entity = restResponse.getEntity();
        if (!entity.isEmpty()) {
            individualResponse.setBody(new IndividualBody(DataMapConverter.bytesToDataMap((Map)restResponse.getHeaders(), (ByteString)entity)));
        }
        return individualResponse;
    }

    private static IndividualResponseWithCookies createInternalServerErrorResponse(String message) {
        return new IndividualResponseWithCookies(IndividualResponseException.createInternalServerErrorIndividualResponse(message));
    }

    private static IndividualResponseWithCookies toErrorIndividualResponse(Throwable error) {
        if (error instanceof IndividualResponseException) {
            return new IndividualResponseWithCookies(((IndividualResponseException)error).getResponse());
        }
        return new IndividualResponseWithCookies(IndividualResponseException.createInternalServerErrorIndividualResponse(error));
    }
}

