/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server;

import com.linkedin.parseq.Engine;
import com.linkedin.parseq.EngineBuilder;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcher;
import com.linkedin.r2.transport.http.server.AbstractR2Servlet;
import com.linkedin.r2.transport.http.server.AsyncR2Servlet;
import com.linkedin.r2.transport.http.server.RAPServlet;
import com.linkedin.restli.server.DelegatingTransportDispatcher;
import com.linkedin.restli.server.RestLiConfig;
import com.linkedin.restli.server.RestLiServer;
import com.linkedin.restli.server.resources.PrototypeResourceFactory;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestliServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(RestliServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE_PACKAGES_PARAM = "resourcePackages";
    private static final String PAR_SEQ_THREAD_POOL_SIZE = "parSeqThreadPoolSize";
    private static final String PACKAGE_PARAM_SEPARATOR = ";";
    private static final String USE_ASYNC_PARAM = "useAsync";
    private static final String ASYNC_TIMEOUT_PARAM = "asyncTimeout";
    public static final int DEFAULT_ASYNC_TIMEOUT = 30000;
    private HttpServlet _r2Servlet;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._r2Servlet = this.buildR2ServletFromServletParams(servletConfig);
        this._r2Servlet.init(servletConfig);
    }

    private AbstractR2Servlet buildR2ServletFromServletParams(ServletConfig servletConfig) {
        PrototypeResourceFactory resourceFactory = new PrototypeResourceFactory();
        RestLiConfig config = new RestLiConfig();
        config.setResourcePackageNamesSet(this.getResourcePackageSet(servletConfig));
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(this.getParseqThreadPoolSize(servletConfig));
        Engine engine = new EngineBuilder().setTaskExecutor((Executor)scheduler).setTimerScheduler(scheduler).build();
        RestLiServer restLiServer = new RestLiServer(config, resourceFactory, engine);
        DelegatingTransportDispatcher dispatcher = new DelegatingTransportDispatcher(restLiServer, restLiServer);
        boolean useAsync = this.getUseAsync(servletConfig);
        long asyncTimeOut = this.getAsyncTimeout(servletConfig);
        if (useAsync && servletConfig.getServletContext().getMajorVersion() < 3) {
            throw new IllegalArgumentException("This servlet is configured with useAsync=true, but the current servlet context does not support the required Servlet API 3.0.");
        }
        if (!useAsync) {
            log.info("Initializing Rest.li with a thread based request handling.  Set useAsync=true on a Servlet API 3.0 container to enable Rest.li's async servlet.");
            return new RAPServlet((TransportDispatcher)dispatcher);
        }
        log.info("Initializing Rest.li with an async request handling enabled.");
        return new AsyncR2Servlet((TransportDispatcher)dispatcher, asyncTimeOut);
    }

    private boolean getUseAsync(ServletConfig servletConfig) {
        String useAsync = servletConfig.getInitParameter(USE_ASYNC_PARAM);
        if (useAsync != null) {
            return Boolean.parseBoolean(useAsync);
        }
        return servletConfig.getServletContext().getMajorVersion() >= 3;
    }

    private long getAsyncTimeout(ServletConfig servletConfig) {
        String asyncTimeout = servletConfig.getInitParameter(ASYNC_TIMEOUT_PARAM);
        if (asyncTimeout != null) {
            return Long.parseLong(asyncTimeout);
        }
        return 30000L;
    }

    private Set<String> getResourcePackageSet(ServletConfig servletConfig) {
        String resourcePackages = servletConfig.getInitParameter(RESOURCE_PACKAGES_PARAM);
        HashSet<String> resourcePackageSet = new HashSet<String>();
        for (String resourcePackage : resourcePackages.split(PACKAGE_PARAM_SEPARATOR)) {
            resourcePackageSet.add(resourcePackage.trim());
        }
        return resourcePackageSet;
    }

    private int getParseqThreadPoolSize(ServletConfig servletConfig) {
        int threadPoolSize;
        String threadPoolSizeStr = servletConfig.getInitParameter(PAR_SEQ_THREAD_POOL_SIZE);
        if (StringUtils.isNumeric((String)threadPoolSizeStr) && !threadPoolSizeStr.isEmpty()) {
            threadPoolSize = Integer.valueOf(threadPoolSizeStr);
        } else {
            int numCores = Runtime.getRuntime().availableProcessors();
            threadPoolSize = numCores + 1;
        }
        return threadPoolSize;
    }

    public void destroy() {
        this._r2Servlet.destroy();
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        this._r2Servlet.service(req, res);
    }
}

