/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.internal.server.ResponseType;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.internal.server.response.RestLiResponseEnvelope;
import com.linkedin.restli.server.RestLiServiceException;
import java.util.Map;

public abstract class BatchResponseEnvelope
extends RestLiResponseEnvelope {
    protected Map<?, BatchResponseEntry> _batchResponseMap;

    protected BatchResponseEnvelope(Map<?, BatchResponseEntry> batchResponseMap, RestLiResponseDataImpl restLiResponseData) {
        super(restLiResponseData);
        this._batchResponseMap = batchResponseMap;
    }

    public void setBatchResponseMap(Map<?, BatchResponseEntry> batchResponseMap, HttpStatus httpStatus) {
        this._restLiResponseData.setStatus(httpStatus);
        this._batchResponseMap = batchResponseMap;
    }

    public Map<?, BatchResponseEntry> getBatchResponseMap() {
        return this._batchResponseMap;
    }

    @Override
    protected void clearData() {
        this._batchResponseMap = null;
    }

    @Override
    public final ResponseType getResponseType() {
        return ResponseType.BATCH_ENTITIES;
    }

    public static final class BatchResponseEntry {
        private RecordTemplate _recordTemplate;
        private RestLiServiceException _restLiServiceException;
        private HttpStatus _httpStatus;

        public BatchResponseEntry(HttpStatus httpStatus, RecordTemplate recordTemplate) {
            this._httpStatus = httpStatus;
            this._recordTemplate = recordTemplate;
            this._restLiServiceException = null;
        }

        public BatchResponseEntry(HttpStatus httpStatus, RestLiServiceException exception) {
            this._httpStatus = httpStatus;
            this._recordTemplate = null;
            this._restLiServiceException = exception;
        }

        public RecordTemplate getRecord() {
            return this._recordTemplate;
        }

        public HttpStatus getStatus() {
            return this._httpStatus;
        }

        public boolean hasException() {
            return this._restLiServiceException != null;
        }

        public RestLiServiceException getException() {
            return this._restLiServiceException;
        }
    }
}

