/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.BatchResponse;
import com.linkedin.restli.common.EntityResponse;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.internal.common.URIParamUtils;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.ServerResourceContext;
import com.linkedin.restli.internal.server.methods.AnyRecord;
import com.linkedin.restli.internal.server.response.BatchGetResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchResponseEnvelope;
import com.linkedin.restli.internal.server.response.ErrorResponseBuilder;
import com.linkedin.restli.internal.server.response.PartialRestResponse;
import com.linkedin.restli.internal.server.response.ResponseUtils;
import com.linkedin.restli.internal.server.response.RestLiResponseBuilder;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.internal.server.util.RestUtils;
import com.linkedin.restli.server.BatchResult;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;
import java.net.HttpCookie;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchGetResponseBuilder
implements RestLiResponseBuilder {
    private final ErrorResponseBuilder _errorResponseBuilder;

    public BatchGetResponseBuilder(ErrorResponseBuilder errorResponseBuilder) {
        this._errorResponseBuilder = errorResponseBuilder;
    }

    @Override
    public PartialRestResponse buildResponse(RoutingResult routingResult, RestLiResponseData responseData) {
        Map<Object, BatchResponseEnvelope.BatchResponseEntry> responses = responseData.getBatchResponseEnvelope().getBatchResponseMap();
        Map<Object, EntityResponse<RecordTemplate>> entityBatchResponse = this.buildEntityResponse(routingResult, responses);
        PartialRestResponse.Builder builder = new PartialRestResponse.Builder();
        ProtocolVersion protocolVersion = ((ServerResourceContext)routingResult.getContext()).getRestliProtocolVersion();
        BatchResponse<AnyRecord> response = BatchGetResponseBuilder.toBatchResponse(entityBatchResponse, protocolVersion);
        builder.entity((RecordTemplate)response);
        return builder.headers(responseData.getHeaders()).cookies(responseData.getCookies()).build();
    }

    private Map<Object, EntityResponse<RecordTemplate>> buildEntityResponse(RoutingResult routingResult, Map<Object, BatchResponseEnvelope.BatchResponseEntry> mergedResponse) {
        HashMap<Object, EntityResponse<RecordTemplate>> entityBatchResponse = new HashMap<Object, EntityResponse<RecordTemplate>>(mergedResponse.size());
        for (Map.Entry<Object, BatchResponseEnvelope.BatchResponseEntry> entry : mergedResponse.entrySet()) {
            EntityResponse<RecordTemplate> entityResponse;
            EntityResponse<RecordTemplate> entityResponse2 = entityResponse = entry.getValue().hasException() ? BatchGetResponseBuilder.createEntityResponse(null) : BatchGetResponseBuilder.createEntityResponse(entry.getValue().getRecord());
            if (entry.getKey() == null) {
                throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null errors Map found inside of the result returned by the resource method: " + routingResult.getResourceMethod());
            }
            entityResponse.setStatus(entry.getValue().getStatus(), SetMode.IGNORE_NULL);
            if (entry.getValue().hasException()) {
                entityResponse.setError(this._errorResponseBuilder.buildErrorResponse(entry.getValue().getException()));
            }
            entityBatchResponse.put(entry.getKey(), entityResponse);
        }
        return entityBatchResponse;
    }

    private static EntityResponse<RecordTemplate> createEntityResponse(RecordTemplate entityTemplate) {
        EntityResponse entityResponse;
        if (entityTemplate == null) {
            entityResponse = new EntityResponse(null);
        } else {
            Class<?> entityClass = entityTemplate.getClass();
            entityResponse = new EntityResponse(entityClass);
            CheckedUtil.putWithoutChecking((CheckedMap)entityResponse.data(), (Object)"entity", (Object)entityTemplate.data());
        }
        return entityResponse;
    }

    @Override
    public RestLiResponseData buildRestLiResponseData(RestRequest request, RoutingResult routingResult, Object result, Map<String, String> headers, List<HttpCookie> cookies) {
        Map entities = (Map)result;
        Map statuses = Collections.emptyMap();
        Map serviceErrors = Collections.emptyMap();
        if (result instanceof BatchResult) {
            BatchResult batchResult2 = (BatchResult)result;
            statuses = batchResult2.getStatuses();
            serviceErrors = batchResult2.getErrors();
        }
        try {
            if (statuses.containsKey(null)) {
                throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null key inside of a Map returned by the resource method: " + routingResult.getResourceMethod());
            }
        }
        catch (NullPointerException batchResult2) {
            // empty catch block
        }
        HashMap<Object, BatchResponseEnvelope.BatchResponseEntry> batchResult = new HashMap<Object, BatchResponseEnvelope.BatchResponseEntry>(entities.size() + serviceErrors.size());
        for (Map.Entry entry : entities.entrySet()) {
            if (entry.getKey() == null) {
                throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null key inside of a Map returned by the resource method: " + routingResult.getResourceMethod());
            }
            Object object = ResponseUtils.translateCanonicalKeyToAlternativeKeyIfNeeded(entry.getKey(), routingResult);
            DataMap projectedData = RestUtils.projectFields(((RecordTemplate)entry.getValue()).data(), routingResult.getContext().getProjectionMode(), routingResult.getContext().getProjectionMask());
            AnyRecord anyRecord = new AnyRecord(projectedData);
            batchResult.put(object, new BatchResponseEnvelope.BatchResponseEntry((HttpStatus)statuses.get(entry.getKey()), anyRecord));
        }
        for (Map.Entry entry : serviceErrors.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null key inside of a Map returned by the resource method: " + routingResult.getResourceMethod());
            }
            Object object = ResponseUtils.translateCanonicalKeyToAlternativeKeyIfNeeded(entry.getKey(), routingResult);
            batchResult.put(object, new BatchResponseEnvelope.BatchResponseEntry((HttpStatus)statuses.get(entry.getKey()), (RestLiServiceException)entry.getValue()));
        }
        Map<Object, RestLiServiceException> contextErrors = ((ServerResourceContext)routingResult.getContext()).getBatchKeyErrors();
        for (Map.Entry<Object, RestLiServiceException> entry : contextErrors.entrySet()) {
            Object finalKey2 = ResponseUtils.translateCanonicalKeyToAlternativeKeyIfNeeded(entry.getKey(), routingResult);
            batchResult.put(finalKey2, new BatchResponseEnvelope.BatchResponseEntry((HttpStatus)statuses.get(entry.getKey()), entry.getValue()));
        }
        RestLiResponseDataImpl restLiResponseDataImpl = new RestLiResponseDataImpl(HttpStatus.S_200_OK, headers, cookies);
        restLiResponseDataImpl.setResponseEnvelope(new BatchGetResponseEnvelope(batchResult, restLiResponseDataImpl));
        return restLiResponseDataImpl;
    }

    private static <K, V extends RecordTemplate> BatchResponse<AnyRecord> toBatchResponse(Map<K, EntityResponse<V>> entities, ProtocolVersion protocolVersion) {
        DataMap splitResponseData = new DataMap();
        DataMap splitResults = new DataMap();
        DataMap splitStatuses = new DataMap();
        DataMap splitErrors = new DataMap();
        for (Map.Entry<K, EntityResponse<V>> resultEntry : entities.entrySet()) {
            DataMap error;
            Integer status;
            DataMap entityResponseData = resultEntry.getValue().data();
            String stringKey = URIParamUtils.encodeKeyForBody(resultEntry.getKey(), (boolean)false, (ProtocolVersion)protocolVersion);
            DataMap entityData = entityResponseData.getDataMap("entity");
            if (entityData != null) {
                CheckedUtil.putWithoutChecking((CheckedMap)splitResults, (Object)stringKey, (Object)entityData);
            }
            if ((status = entityResponseData.getInteger("status")) != null) {
                CheckedUtil.putWithoutChecking((CheckedMap)splitStatuses, (Object)stringKey, (Object)status);
            }
            if ((error = entityResponseData.getDataMap("error")) == null) continue;
            CheckedUtil.putWithoutChecking((CheckedMap)splitErrors, (Object)stringKey, (Object)error);
        }
        CheckedUtil.putWithoutChecking((CheckedMap)splitResponseData, (Object)"results", (Object)splitResults);
        CheckedUtil.putWithoutChecking((CheckedMap)splitResponseData, (Object)"statuses", (Object)splitStatuses);
        CheckedUtil.putWithoutChecking((CheckedMap)splitResponseData, (Object)"errors", (Object)splitErrors);
        return new BatchResponse(splitResponseData, AnyRecord.class);
    }
}

