/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.restli.common.CreateIdStatus;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.internal.server.ResponseType;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.internal.server.response.RestLiResponseEnvelope;
import com.linkedin.restli.server.RestLiServiceException;
import java.util.List;

public class BatchCreateResponseEnvelope
extends RestLiResponseEnvelope {
    protected List<CollectionCreateResponseItem> _createResponses;
    private final boolean _isGetAfterCreate;

    BatchCreateResponseEnvelope(List<CollectionCreateResponseItem> createResponses, RestLiResponseDataImpl restLiResponseData) {
        this(createResponses, false, restLiResponseData);
    }

    BatchCreateResponseEnvelope(List<CollectionCreateResponseItem> createResponses, boolean isGetAfterCreate, RestLiResponseDataImpl restLiResponseData) {
        super(restLiResponseData);
        this._createResponses = createResponses;
        this._isGetAfterCreate = isGetAfterCreate;
    }

    @Override
    public ResourceMethod getResourceMethod() {
        return ResourceMethod.BATCH_CREATE;
    }

    public boolean isGetAfterCreate() {
        return this._isGetAfterCreate;
    }

    public List<CollectionCreateResponseItem> getCreateResponses() {
        return this._createResponses;
    }

    public void setCreateResponse(List<CollectionCreateResponseItem> createResponse, HttpStatus httpStatus) {
        this._restLiResponseData.setStatus(httpStatus);
        this._createResponses = createResponse;
    }

    @Override
    protected void clearData() {
        this._createResponses = null;
    }

    @Override
    public ResponseType getResponseType() {
        return ResponseType.CREATE_COLLECTION;
    }

    public static final class CollectionCreateResponseItem {
        private CreateIdStatus<?> _recordResponse;
        private Object _id;
        private RestLiServiceException _exception;

        public CollectionCreateResponseItem(CreateIdStatus response) {
            this.setCollectionCreateResponseItem(response);
        }

        public CollectionCreateResponseItem(RestLiServiceException exception, Object id) {
            this.setCollectionCreateResponseItem(exception, id);
        }

        public void setCollectionCreateResponseItem(CreateIdStatus<?> response) {
            this._recordResponse = response;
            this._id = null;
            this._exception = null;
        }

        public void setCollectionCreateResponseItem(RestLiServiceException exception, Object id) {
            this._exception = exception;
            this._id = id;
            this._recordResponse = null;
        }

        public CreateIdStatus<?> getRecord() {
            return this._recordResponse;
        }

        public Object getId() {
            return this._id;
        }

        public boolean isErrorResponse() {
            return this._exception != null;
        }

        public RestLiServiceException getException() {
            return this._exception;
        }
    }
}

