/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.model;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.internal.common.util.CollectionUtils;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.internal.server.model.ResourceMethodDescriptor;
import com.linkedin.restli.internal.server.model.ResourceType;
import com.linkedin.restli.server.AlternativeKey;
import com.linkedin.restli.server.Key;
import com.linkedin.restli.server.ResourceLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResourceModel {
    private final String _name;
    private final String _namespace;
    private final Class<?> _resourceClass;
    private final ResourceType _resourceType;
    private final boolean _root;
    private final Class<?> _parentResourceClass;
    private ResourceModel _parentResourceModel;
    private final Set<Key> _keys;
    private final Key _primaryKey;
    private final Class<? extends RecordTemplate> _keyKeyClass;
    private final Class<? extends RecordTemplate> _keyParamsClass;
    private Map<String, AlternativeKey<?, ?>> _alternativeKeys;
    private final Map<String, Class<?>> _keyClasses;
    private final Class<? extends RecordTemplate> _valueClass;
    private final List<ResourceMethodDescriptor> _resourceMethodDescriptors;
    private final Map<String, ResourceModel> _pathSubResourceMap;
    private DataMap _customAnnotations;

    public ResourceModel(Key primaryKey, Class<? extends RecordTemplate> keyKeyClass, Class<? extends RecordTemplate> keyParamsClass, Set<Key> keys, Class<? extends RecordTemplate> valueClass, Class<?> resourceClass, Class<?> parentResourceClass, String name, ResourceType resourceType, String namespace) {
        this._keyKeyClass = keyKeyClass;
        this._keyParamsClass = keyParamsClass;
        this._keys = keys;
        this._keyClasses = new HashMap(CollectionUtils.getMapInitialCapacity((int)this._keys.size(), (float)0.75f), 0.75f);
        for (Key key : this._keys) {
            this._keyClasses.put(key.getName(), key.getType());
        }
        this._valueClass = valueClass;
        this._resourceClass = resourceClass;
        this._name = name;
        this._namespace = namespace;
        this._root = parentResourceClass == null;
        this._parentResourceClass = parentResourceClass;
        this._resourceMethodDescriptors = new ArrayList<ResourceMethodDescriptor>(5);
        this._primaryKey = primaryKey;
        this._resourceType = resourceType;
        this._pathSubResourceMap = new HashMap<String, ResourceModel>();
    }

    public ResourceModel(Class<? extends RecordTemplate> valueClass, Class<?> resourceClass, Class<?> parentResourceClass, String name, ResourceType resourceType, String namespace) {
        this(null, null, null, Collections.emptySet(), valueClass, resourceClass, parentResourceClass, name, resourceType, namespace);
    }

    public ResourceType getResourceType() {
        return this._resourceType;
    }

    public ResourceLevel getResourceLevel() {
        switch (this._resourceType) {
            case COLLECTION: 
            case ASSOCIATION: 
            case ACTIONS: {
                return ResourceLevel.COLLECTION;
            }
            case SIMPLE: {
                return ResourceLevel.ENTITY;
            }
        }
        return ResourceLevel.ANY;
    }

    public Class<?> getKeyClass() {
        return this._primaryKey == null ? null : this._primaryKey.getType();
    }

    public Set<Key> getKeys() {
        return this._keys;
    }

    public Map<String, Class<?>> getKeyClasses() {
        return this._keyClasses;
    }

    public Key getKey(String name) {
        for (Key key : this._keys) {
            if (!key.getName().equals(name)) continue;
            return key;
        }
        return null;
    }

    public Set<String> getKeyNames() {
        HashSet<String> keyNames = new HashSet<String>();
        for (Key key : this._keys) {
            keyNames.add(key.getName());
        }
        return keyNames;
    }

    public void putAlternativeKeys(Map<String, AlternativeKey<?, ?>> alternativeKeys) {
        this._alternativeKeys = alternativeKeys;
    }

    public Map<String, AlternativeKey<?, ?>> getAlternativeKeys() {
        return this._alternativeKeys;
    }

    public void addResourceMethodDescriptor(ResourceMethodDescriptor methodDescriptor) {
        methodDescriptor.setResourceModel(this);
        this._resourceMethodDescriptors.add(methodDescriptor);
    }

    public Class<? extends RecordTemplate> getValueClass() {
        return this._valueClass;
    }

    public ResourceModel getParentResourceModel() {
        return this._parentResourceModel;
    }

    public Class<?> getParentResourceClass() {
        return this._parentResourceClass;
    }

    public void setParentResourceModel(ResourceModel parentResourceModel) {
        this._parentResourceModel = parentResourceModel;
    }

    public void setCustomAnnotation(DataMap customAnnotationData) {
        this._customAnnotations = customAnnotationData;
    }

    public void addSubResource(String path, ResourceModel resourceModel) {
        this._pathSubResourceMap.put(path, resourceModel);
    }

    public <R extends ResourceModel> R getSubResource(String subresourceName) {
        return (R)this._pathSubResourceMap.get(subresourceName);
    }

    public Iterable<ResourceModel> getSubResources() {
        return this._pathSubResourceMap.values();
    }

    public boolean hasSubResources() {
        return this._pathSubResourceMap.size() > 0;
    }

    public Class<?> getResourceClass() {
        return this._resourceClass;
    }

    public String getName() {
        return this._name;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public boolean isRoot() {
        return this._root;
    }

    public List<ResourceMethodDescriptor> getResourceMethodDescriptors() {
        return this._resourceMethodDescriptors;
    }

    public boolean isActions() {
        return ResourceType.ACTIONS.equals((Object)this.getResourceType());
    }

    public final ResourceMethodDescriptor matchMethod(ResourceMethod type, String name, ResourceLevel resourceLevel) {
        if (type.equals((Object)ResourceMethod.ACTION)) {
            return this.findActionMethod(name, resourceLevel);
        }
        if (type.equals((Object)ResourceMethod.FINDER)) {
            return this.findNamedMethod(name);
        }
        return this.findMethod(type);
    }

    public final ResourceMethodDescriptor findMethod(ResourceMethod type) {
        for (ResourceMethodDescriptor methodDescriptor : this._resourceMethodDescriptors) {
            if (!methodDescriptor.getType().equals((Object)type)) continue;
            return methodDescriptor;
        }
        return null;
    }

    public final ResourceMethodDescriptor findActionMethod(String actionName, ResourceLevel resourceLevel) {
        for (ResourceMethodDescriptor methodDescriptor : this._resourceMethodDescriptors) {
            if (!methodDescriptor.getType().equals((Object)ResourceMethod.ACTION) || !actionName.equals(methodDescriptor.getActionName()) || !methodDescriptor.getActionResourceLevel().equals((Object)resourceLevel)) continue;
            return methodDescriptor;
        }
        return null;
    }

    public final ResourceMethodDescriptor findNamedMethod(String name) {
        for (ResourceMethodDescriptor methodDescriptor : this._resourceMethodDescriptors) {
            if (!ResourceMethod.FINDER.equals((Object)methodDescriptor.getType()) || !name.equals(methodDescriptor.getFinderName())) continue;
            return methodDescriptor;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + (this._resourceClass == null ? 0 : this._resourceClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceModel other = (ResourceModel)obj;
        if (!this._namespace.equals(other._namespace)) {
            return false;
        }
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        return !(this._resourceClass == null ? other._resourceClass != null : !this._resourceClass.equals(other._resourceClass));
    }

    public String getKeyName() {
        return this._primaryKey == null ? null : this._primaryKey.getName();
    }

    public Key getPrimaryKey() {
        return this._primaryKey;
    }

    public Class<? extends RecordTemplate> getKeyKeyClass() {
        return this._keyKeyClass;
    }

    public Class<? extends RecordTemplate> getKeyParamsClass() {
        return this._keyParamsClass;
    }

    public DataMap getCustomAnnotationData() {
        return this._customAnnotations;
    }
}

