/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.model;

import com.linkedin.restli.common.ResourceMethod;
import java.util.HashMap;
import java.util.Map;

public final class ResourceMethodLookup {
    private static final Map<String, ResourceMethod> _methodNameToResourceMethodMap = new HashMap<String, ResourceMethod>(ResourceMethod.values().length);

    private ResourceMethodLookup() {
    }

    private static String includePartial(String methodName, boolean partial) {
        if (partial) {
            methodName = "partial" + methodName;
        }
        return methodName;
    }

    public static ResourceMethod fromResourceMethodName(String resourceMethodName, boolean partial) {
        return _methodNameToResourceMethodMap.get(ResourceMethodLookup.includePartial(resourceMethodName, partial));
    }

    static {
        _methodNameToResourceMethodMap.put(ResourceMethodLookup.includePartial("create", false), ResourceMethod.CREATE);
        _methodNameToResourceMethodMap.put(ResourceMethodLookup.includePartial("batchCreate", false), ResourceMethod.BATCH_CREATE);
        _methodNameToResourceMethodMap.put(ResourceMethodLookup.includePartial("get", false), ResourceMethod.GET);
        _methodNameToResourceMethodMap.put(ResourceMethodLookup.includePartial("batchGet", false), ResourceMethod.BATCH_GET);
        _methodNameToResourceMethodMap.put(ResourceMethodLookup.includePartial("update", false), ResourceMethod.UPDATE);
        _methodNameToResourceMethodMap.put(ResourceMethodLookup.includePartial("batchUpdate", false), ResourceMethod.BATCH_UPDATE);
        _methodNameToResourceMethodMap.put(ResourceMethodLookup.includePartial("update", true), ResourceMethod.PARTIAL_UPDATE);
        _methodNameToResourceMethodMap.put(ResourceMethodLookup.includePartial("batchUpdate", true), ResourceMethod.BATCH_PARTIAL_UPDATE);
        _methodNameToResourceMethodMap.put(ResourceMethodLookup.includePartial("delete", false), ResourceMethod.DELETE);
        _methodNameToResourceMethodMap.put(ResourceMethodLookup.includePartial("batchDelete", false), ResourceMethod.BATCH_DELETE);
        _methodNameToResourceMethodMap.put(ResourceMethodLookup.includePartial("getAll", false), ResourceMethod.GET_ALL);
    }
}

