/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.model;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.FieldDef;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.internal.server.model.Parameter;
import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.server.ResourceLevel;
import com.linkedin.restli.server.RestLiMethodContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResourceMethodDescriptor
implements RestLiMethodContext {
    private ResourceModel _resourceModel;
    private final ResourceMethod _type;
    private final Method _method;
    private final List<Parameter<?>> _parameters;
    private final String _finderName;
    private final Class<? extends RecordTemplate> _finderMetadataType;
    private final String _actionName;
    private final ResourceLevel _actionResourceLevel;
    private final FieldDef<?> _actionReturnFieldDef;
    private final RecordDataSchema _actionReturnRecordDataSchema;
    private final RecordDataSchema _requestDataSchema;
    private final InterfaceType _interfaceType;
    private final DataMap _customAnnotations;

    public static ResourceMethodDescriptor createForFinder(Method method, List<Parameter<?>> parameters, String finderName, Class<? extends RecordTemplate> metadataType, InterfaceType interfaceType, DataMap customAnnotations) {
        return new ResourceMethodDescriptor(ResourceMethod.FINDER, method, parameters, finderName, null, null, null, null, null, metadataType, interfaceType, customAnnotations);
    }

    public static ResourceMethodDescriptor createForAction(Method method, List<Parameter<?>> parameters, String actionName, ResourceLevel actionResourceType, FieldDef<?> actionReturnType, RecordDataSchema actionReturnRecordDataSchema, RecordDataSchema recordDataSchema, InterfaceType interfaceType, DataMap customAnnotations) {
        return new ResourceMethodDescriptor(ResourceMethod.ACTION, method, parameters, null, actionName, actionResourceType, actionReturnType, actionReturnRecordDataSchema, recordDataSchema, null, interfaceType, customAnnotations);
    }

    public static ResourceMethodDescriptor createForRestful(ResourceMethod type, Method method, InterfaceType interfaceType) {
        return ResourceMethodDescriptor.createForRestful(type, method, Collections.emptyList(), interfaceType, null);
    }

    public static ResourceMethodDescriptor createForRestful(ResourceMethod type, Method method, List<Parameter<?>> parameters, InterfaceType interfaceType, DataMap customAnnotations) {
        return new ResourceMethodDescriptor(type, method, parameters, null, null, null, null, null, null, null, interfaceType, customAnnotations);
    }

    private ResourceMethodDescriptor(ResourceMethod type, Method method, List<Parameter<?>> parameters, String finderName, String actionName, ResourceLevel actionResourceLevel, FieldDef<?> actionReturnType, RecordDataSchema actionReturnRecordDataSchema, RecordDataSchema requestDataSchema, Class<? extends RecordTemplate> finderMetadataType, InterfaceType interfaceType, DataMap customAnnotations) {
        this._type = type;
        this._method = method;
        this._parameters = parameters;
        this._finderName = finderName;
        this._actionName = actionName;
        this._actionResourceLevel = actionResourceLevel;
        this._actionReturnFieldDef = actionReturnType;
        this._actionReturnRecordDataSchema = actionReturnRecordDataSchema;
        this._requestDataSchema = requestDataSchema;
        this._finderMetadataType = finderMetadataType;
        this._interfaceType = interfaceType;
        this._customAnnotations = customAnnotations;
    }

    public ResourceModel getResourceModel() {
        return this._resourceModel;
    }

    public void setResourceModel(ResourceModel resourceModel) {
        this._resourceModel = resourceModel;
    }

    public ResourceMethod getType() {
        return this._type;
    }

    public Method getMethod() {
        return this._method;
    }

    public List<Parameter<?>> getParameters() {
        return this._parameters;
    }

    public List<Parameter<?>> getParametersWithType(Parameter.ParamType type) {
        ArrayList params = new ArrayList();
        for (Parameter<?> p : this._parameters) {
            if (p.getParamType() != type) continue;
            params.add(p);
        }
        return params;
    }

    public <T> Parameter<T> getParameter(String name) {
        for (Parameter<?> p : this._parameters) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public String getFinderName() {
        return this._finderName;
    }

    public Class<? extends RecordTemplate> getFinderMetadataType() {
        return this._finderMetadataType;
    }

    @Override
    public String getActionName() {
        return this._actionName;
    }

    @Override
    public String getResourceName() {
        return this._resourceModel.getName();
    }

    @Override
    public String getNamespace() {
        return this._resourceModel.getNamespace();
    }

    @Override
    public ResourceMethod getMethodType() {
        return this._type;
    }

    public ResourceLevel getActionResourceLevel() {
        return this._actionResourceLevel;
    }

    public Class<?> getActionReturnType() {
        if (this._actionReturnFieldDef == null) {
            return Void.TYPE;
        }
        return this._actionReturnFieldDef.getType();
    }

    public FieldDef<?> getActionReturnFieldDef() {
        return this._actionReturnFieldDef;
    }

    public RecordDataSchema getActionReturnRecordDataSchema() {
        return this._actionReturnRecordDataSchema;
    }

    public RecordDataSchema getRequestDataSchema() {
        return this._requestDataSchema;
    }

    public int indexOfParameterType(Parameter.ParamType type) {
        for (int i = 0; i < this._parameters.size(); ++i) {
            if (!this._parameters.get(i).getParamType().equals((Object)type)) continue;
            return i;
        }
        return -1;
    }

    public InterfaceType getInterfaceType() {
        return this._interfaceType;
    }

    public DataMap getCustomAnnotationData() {
        return this._customAnnotations;
    }

    public boolean isPagingSupported() {
        return this._parameters.stream().anyMatch(param -> param.getParamType().equals((Object)Parameter.ParamType.PAGING_CONTEXT_PARAM));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("type=").append(this._type);
        sb.append(", ");
        sb.append("resourceName=").append(this._resourceModel.getName());
        if (this._finderName != null) {
            sb.append(", ").append("finderName=").append(this._finderName);
        }
        if (this._actionName != null) {
            sb.append(", ").append("actionName=").append(this._actionName);
        }
        return sb.toString();
    }

    public static enum InterfaceType {
        SYNC,
        CALLBACK,
        PROMISE,
        TASK;

    }
}

