/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.model;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AnnotationSet {
    private final Map<Class<? extends Annotation>, Annotation> _map = new HashMap<Class<? extends Annotation>, Annotation>();
    public static final AnnotationSet EMPTY = new AnnotationSet(new Annotation[0]);

    public AnnotationSet(Annotation[] annos) {
        for (Annotation anno : annos) {
            this._map.put(anno.annotationType(), anno);
        }
    }

    public boolean contains(Class<? extends Annotation> clazz) {
        return this._map.containsKey(clazz);
    }

    public <T extends Annotation> T get(Class<T> clazz) {
        return (T)((Annotation)clazz.cast(this._map.get(clazz)));
    }

    public int count(Class<? extends Annotation> ... classes) {
        int result = 0;
        for (Class<? extends Annotation> clazz : classes) {
            if (!this._map.containsKey(clazz)) continue;
            ++result;
        }
        return result;
    }

    public Annotation[] getAll() {
        Collection<Annotation> allAnnotations = this._map.values();
        return allAnnotations.toArray(new Annotation[allAnnotations.size()]);
    }
}

