/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.methods.arguments;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.message.rest.RestMessage;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.CollectionRequest;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.methods.arguments.ArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.RestLiArgumentBuilder;
import com.linkedin.restli.internal.server.util.ArgumentUtils;
import com.linkedin.restli.internal.server.util.DataMapUtils;
import com.linkedin.restli.server.BatchCreateRequest;
import com.linkedin.restli.server.RestLiRequestData;
import com.linkedin.restli.server.RestLiRequestDataImpl;

public class BatchCreateArgumentBuilder
implements RestLiArgumentBuilder {
    @Override
    public Object[] buildArguments(RestLiRequestData requestData, RoutingResult routingResult) {
        BatchCreateRequest batchRequest = new BatchCreateRequest(requestData.getBatchEntities());
        Object[] positionalArguments = new Object[]{batchRequest};
        return ArgumentBuilder.buildArgs(positionalArguments, routingResult.getResourceMethod(), routingResult.getContext(), null);
    }

    @Override
    public RestLiRequestData extractRequestData(RoutingResult routingResult, RestRequest request) {
        Class<? extends RecordTemplate> valueClass = ArgumentUtils.getValueClass(routingResult);
        DataMap dataMap = DataMapUtils.readMap((RestMessage)request);
        CollectionRequest collectionRequest = new CollectionRequest(dataMap, valueClass);
        return new RestLiRequestDataImpl.Builder().batchEntities(collectionRequest.getElements()).build();
    }
}

