/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server;

import com.linkedin.restli.common.ResourceMethod;
import java.util.Arrays;
import java.util.List;

public enum ResponseType {
    SINGLE_ENTITY(ResourceMethod.GET, ResourceMethod.ACTION, ResourceMethod.CREATE),
    GET_COLLECTION(ResourceMethod.GET_ALL, ResourceMethod.FINDER),
    CREATE_COLLECTION(ResourceMethod.BATCH_CREATE),
    BATCH_ENTITIES(ResourceMethod.BATCH_GET, ResourceMethod.BATCH_UPDATE, ResourceMethod.BATCH_PARTIAL_UPDATE, ResourceMethod.BATCH_DELETE),
    STATUS_ONLY(ResourceMethod.PARTIAL_UPDATE, ResourceMethod.UPDATE, ResourceMethod.DELETE, ResourceMethod.OPTIONS);

    private final List<ResourceMethod> _methodTypes;

    private ResponseType(ResourceMethod ... types) {
        this._methodTypes = Arrays.asList(types);
    }

    public static ResponseType fromMethodType(ResourceMethod type) {
        if (type == null) {
            return STATUS_ONLY;
        }
        for (ResponseType responseType : ResponseType.values()) {
            if (!responseType._methodTypes.contains(type)) continue;
            return responseType;
        }
        throw new UnsupportedOperationException("Unexpected resource method found: " + type.toString());
    }
}

