/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import com.linkedin.r2.transport.common.WireAttributeHelper;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.client.HttpNettyClient;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
class RAPResponseHandler
extends SimpleChannelInboundHandler<RestResponse> {
    private static Logger LOG = LoggerFactory.getLogger(RAPResponseHandler.class);
    public static final AttributeKey<TransportCallback<RestResponse>> CALLBACK_ATTR_KEY = AttributeKey.valueOf((String)"Callback");

    RAPResponseHandler() {
    }

    protected void channelRead0(ChannelHandlerContext ctx, RestResponse response) throws Exception {
        TreeMap headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        TreeMap wireAttrs = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        headers.putAll(response.getHeaders());
        wireAttrs.putAll(WireAttributeHelper.removeWireAttributes(headers));
        RestResponse newResponse = ((RestResponseBuilder)new RestResponseBuilder(response).unsafeSetHeaders(headers)).build();
        TransportCallback callback = (TransportCallback)ctx.channel().attr(CALLBACK_ATTR_KEY).getAndRemove();
        if (callback != null) {
            LOG.debug("{}: handling a response", (Object)ctx.channel().remoteAddress());
            callback.onResponse(TransportResponseImpl.success((Object)newResponse, wireAttrs));
        } else {
            LOG.debug("{}: dropped a response", (Object)ctx.channel().remoteAddress());
        }
        ctx.fireChannelRead((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        TransportCallback callback = (TransportCallback)ctx.channel().attr(CALLBACK_ATTR_KEY).getAndRemove();
        if (callback != null) {
            LOG.debug(ctx.channel().remoteAddress() + ": exception on active channel", cause);
            callback.onResponse(TransportResponseImpl.error((Throwable)HttpNettyClient.toException(cause), Collections.emptyMap()));
        } else {
            LOG.debug(ctx.channel().remoteAddress() + ": exception on idle channel", cause);
        }
        ctx.fireExceptionCaught(cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        TransportCallback callback = (TransportCallback)ctx.channel().attr(CALLBACK_ATTR_KEY).getAndRemove();
        if (callback != null) {
            LOG.debug("{}: active channel closed", (Object)ctx.channel().remoteAddress());
            callback.onResponse(TransportResponseImpl.error((Throwable)new ClosedChannelException(), Collections.emptyMap()));
        } else {
            LOG.debug("{}: idle channel closed", (Object)ctx.channel().remoteAddress());
        }
        ctx.fireChannelInactive();
    }
}

