/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.entitystream.ReadHandle;
import com.linkedin.r2.message.stream.entitystream.Reader;
import com.linkedin.r2.transport.http.client.NettyRequestAdapter;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;

class RAPRequestEncoder
extends ChannelDuplexHandler {
    private static final int MAX_BUFFERED_CHUNKS = 10;
    private static final int FLUSH_THRESHOLD = 8192;
    private volatile BufferedReader _currentReader;

    RAPRequestEncoder() {
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof StreamRequest) {
            StreamRequest request = (StreamRequest)msg;
            HttpRequest nettyRequest = NettyRequestAdapter.toNettyRequest(request);
            ctx.write((Object)nettyRequest, promise);
            this._currentReader = new BufferedReader(ctx, 10, 8192);
            request.getEntityStream().setReader((Reader)this._currentReader);
        } else {
            this._currentReader = null;
            ctx.write(msg, promise);
        }
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (this._currentReader != null) {
            this._currentReader.flush();
        } else {
            ctx.flush();
        }
    }

    private class BufferedReader
    implements Reader {
        private final int _maxBufferedChunks;
        private final int _flushThreshold;
        private final ChannelHandlerContext _ctx;
        private volatile ReadHandle _readHandle;
        private int _notFlushedBytes;
        private int _notFlushedChunks;

        BufferedReader(ChannelHandlerContext ctx, int maxBufferedChunks, int flushThreshold) {
            this._maxBufferedChunks = maxBufferedChunks;
            this._flushThreshold = flushThreshold;
            this._ctx = ctx;
            this._notFlushedBytes = 0;
            this._notFlushedChunks = 0;
        }

        public void onInit(ReadHandle rh) {
            this._readHandle = rh;
        }

        public void onDataAvailable(ByteString data) {
            DefaultHttpContent content = new DefaultHttpContent(Unpooled.wrappedBuffer((ByteBuffer)data.asByteBuffer()));
            this._ctx.write((Object)content).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    BufferedReader.this._readHandle.request(1);
                }
            });
            this._notFlushedBytes += data.length();
            ++this._notFlushedChunks;
            if (this._notFlushedBytes >= this._flushThreshold || this._notFlushedChunks == this._maxBufferedChunks) {
                this._ctx.flush();
                this._notFlushedBytes = 0;
                this._notFlushedChunks = 0;
            }
        }

        public void onDone() {
            RAPRequestEncoder.this._currentReader = null;
            this._ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }

        public void onError(Throwable e) {
            RAPRequestEncoder.this._currentReader = null;
            this._ctx.fireExceptionCaught(e);
        }

        private void flush() {
            this._readHandle.request(this._maxBufferedChunks);
        }
    }
}

