/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.transport.http.client.ChannelPoolStreamHandler;
import com.linkedin.r2.transport.http.client.RAPFullRequestEncoder;
import com.linkedin.r2.transport.http.client.RAPRequestEncoder;
import com.linkedin.r2.transport.http.client.RAPResponseDecoder;
import com.linkedin.r2.transport.http.client.RAPStreamResponseHandler;
import com.linkedin.r2.transport.http.client.SslRequestHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RAPClientPipelineInitializer
extends ChannelInitializer<NioSocketChannel> {
    static final Logger LOG = LoggerFactory.getLogger(RAPClientPipelineInitializer.class);
    private final SSLContext _sslContext;
    private final SSLParameters _sslParameters;
    private final int _maxHeaderSize;
    private final int _maxChunkSize;
    private final long _maxResponseSize;

    RAPClientPipelineInitializer(SSLContext sslContext, SSLParameters sslParameters, int maxHeaderSize, int maxChunkSize, long maxResponseSize) {
        if (sslParameters != null) {
            if (sslContext == null) {
                throw new IllegalArgumentException("SSLParameters passed with no SSLContext");
            }
            SSLParameters supportedSSLParameters = sslContext.getSupportedSSLParameters();
            if (sslParameters.getCipherSuites() != null) {
                this.checkContained(supportedSSLParameters.getCipherSuites(), sslParameters.getCipherSuites(), "cipher suite");
            }
            if (sslParameters.getProtocols() != null) {
                this.checkContained(supportedSSLParameters.getProtocols(), sslParameters.getProtocols(), "protocol");
            }
        }
        this._sslContext = sslContext;
        this._sslParameters = sslParameters;
        this._maxHeaderSize = maxHeaderSize;
        this._maxChunkSize = maxChunkSize;
        this._maxResponseSize = maxResponseSize;
    }

    private void checkContained(String[] containingArray, String[] containedArray, String valueName) {
        HashSet<String> containingSet = new HashSet<String>(Arrays.asList(containingArray));
        HashSet<String> containedSet = new HashSet<String>(Arrays.asList(containedArray));
        boolean changed = containedSet.removeAll(containingSet);
        if (!changed) {
            throw new IllegalArgumentException("None of the requested " + valueName + "s: " + containedSet + " are found in SSLContext");
        }
        if (!containedSet.isEmpty()) {
            for (String paramValue : containedSet) {
                LOG.warn("{} {} requested but not found in SSLContext", (Object)valueName, (Object)paramValue);
            }
        }
    }

    protected void initChannel(NioSocketChannel ch) throws Exception {
        ch.pipeline().addLast("codec", (ChannelHandler)new HttpClientCodec(4096, this._maxHeaderSize, this._maxChunkSize));
        ch.pipeline().addLast("rapFullRequestEncoder", (ChannelHandler)new RAPFullRequestEncoder());
        ch.pipeline().addLast("rapEncoder", (ChannelHandler)new RAPRequestEncoder());
        ch.pipeline().addLast("rapDecoder", (ChannelHandler)new RAPResponseDecoder(this._maxResponseSize));
        ch.pipeline().addLast("responseHandler", (ChannelHandler)new RAPStreamResponseHandler());
        if (this._sslContext != null) {
            ch.pipeline().addLast("sslRequestHandler", (ChannelHandler)new SslRequestHandler(this._sslContext, this._sslParameters));
        }
        ch.pipeline().addLast("channelManager", (ChannelHandler)new ChannelPoolStreamHandler());
    }
}

